
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for plotting
time_spent_on_art = [0, 1, 2, 3, 4, 5]
creativity_scores = [0.6, 0.7, 0.75, 0.8, 0.85, 0.9]
aesthetics_scores = [0.55, 0.65, 0.7, 0.75, 0.78, 0.82]
engagement_scores = [0.5, 0.6, 0.65, 0.7, 0.74, 0.78]

# Extracted variables
creativity_label = "Creativity"
aesthetics_label = "Aesthetics"
engagement_label = "Engagement"

ylim_values = [0.4, 1.0]
yticks_values = [0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
yticks_labels = ["$0.4$", "$0.5$", "$0.6$", "$0.7$", "$0.8$", "$0.9$", "$1.0$"]
xlabel_value = "Time Spent on Art (hrs)"
ylabel_value = "Scores"
xlim_values = [0, 5]
xticks_fontsize = "14"
yticks_fontsize = "14"
xlabel_fontsize = "16"
ylabel_fontsize = "16"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

legend_location = "best"
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
legend_frameon = True

# Plot the data
ax.plot(
    time_spent_on_art,
    creativity_scores,
    "o-",
    label=creativity_label,
    clip_on=False,
    zorder=10,
    color="salmon",
    linewidth=2,
    markersize=10,
)
ax.plot(
    time_spent_on_art,
    aesthetics_scores,
    "d-",
    label=aesthetics_label,
    clip_on=False,
    zorder=10,
    color="cornflowerblue",
    linewidth=2,
    markersize=10,
)
ax.plot(
    time_spent_on_art,
    engagement_scores,
    "s-",
    label=engagement_label,
    clip_on=False,
    zorder=10,
    color="seagreen",
    linewidth=2,
    markersize=10,
)

plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_labels, fontsize=yticks_fontsize)

# Set x-axis to only display specific ticks and extend x-axis to leave space at right
plt.xticks(fontsize=xticks_fontsize)
plt.xlim(xlim_values)
plt.tick_params(axis="both", which="both", color="gray")

# Add legend, labels, and grid
ax.legend(
    loc=legend_location,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
    frameon=legend_frameon,
)
ax.set_xlabel(xlabel_value, fontsize=xlabel_fontsize)
ax.set_ylabel(ylabel_value, fontsize=ylabel_fontsize)
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_116.pdf", bbox_inches="tight")
