
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
years = np.array([2000, 2005, 2010, 2015, 2020, 2025])
population = np.array([50, 58, 66, 74, 82, 90])

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1995, 2030]
xticks_values = np.arange(2000, 2026, 5)

ylabel_value = "Population (in thousands)"
ylim_values = [40, 100]
yticks_values = np.arange(40, 101, 10)
yticklabels = [f"{i}k" for i in range(40, 101, 10)]
title="City Population Growth Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 5))  # Use subplots to get access to the axis object
ax.plot(years, population, marker="s", linestyle="--", color="#ff7f0e")

# Set y-axis to only display specific ticks
ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)
ax.set_ylim(ylim_values)  # Set limits to include a small margin

# Remove minor ticks
ax.tick_params(axis="y", which="minor", left=False)

# Setting x-axis ticks
ax.set_xticks(xticks_values)  # Set x-ticks to be every 5 years
ax.set_xlim(xlim_values)  # Set limits to include a small margin

# Adjusting tick label size
plt.xticks(fontsize=10, fontweight="100")
plt.yticks(fontsize=10, fontweight="100")

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)  # Remove tick marks and set their color

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(title, fontsize=16)

# Show grid with lighter color and only major lines
ax.grid(True, which="major", color="lightgrey", linestyle="-", linewidth=0.5)

# Change the axis colors
ax.spines["bottom"].set_color("#d2d2d2")
ax.spines["top"].set_color("#d2d2d2")  # Optional: hide or set color
ax.spines["left"].set_color("#d2d2d2")
ax.spines["right"].set_color("#d2d2d2")  # Optional: hide or set color

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_119.pdf", bbox_inches="tight")
