
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for a media domain
time_periods = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
views = np.array([100, 200, 250, 400, 600, 800, 850, 900, 950, 1000])
likes = np.array([10, 30, 50, 70, 100, 150, 170, 200, 230, 250])
shares = np.array([5, 10, 15, 30, 60, 80, 90, 100, 120, 150])
comments = np.array([2, 5, 10, 15, 25, 35, 40, 50, 55, 60])

# Axes Limits and Labels
xlabel_value = "Time Periods"
ylabel_value = "Engagement Metrics"

# Labels
label_1 = "Views"
label_2 = "Likes"
label_3 = "Shares"
label_4 = "Comments"

# Titles
title_main = "Social Media Engagement Over Time"
title_1 = "Views and Likes"
title_2 = "Shares and Comments"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 6))

# Use a vibrant color palette
color_1 = "#4CAF50" # Green for Views
color_2 = "#2196F3" # Blue for Likes
color_3 = "#FFC107" # Amber for Shares
color_4 = "#FF5722" # Deep Orange for Comments

# First subplot
plt.subplot(1, 2, 1)
plt.plot(time_periods, views, marker="o", color=color_1, label=label_1, linewidth=2, markersize=6)
plt.plot(time_periods, likes, marker="^", color=color_2, label=label_2, linewidth=2, markersize=6)
plt.fill_between(time_periods, views - 20, views + 20, color=color_1, alpha=0.2)
plt.fill_between(time_periods, likes - 10, likes + 10, color=color_2, alpha=0.2)
plt.title(title_1, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.legend(loc="upper left")

# Second subplot
plt.subplot(1, 2, 2)
plt.plot(time_periods, shares, marker="s", color=color_3, label=label_3, linewidth=2, markersize=6)
plt.plot(time_periods, comments, marker="d", color=color_4, label=label_4, linewidth=2, markersize=6)
plt.fill_between(time_periods, shares - 5, shares + 5, color=color_3, alpha=0.2)
plt.fill_between(time_periods, comments - 3, comments + 3, color=color_4, alpha=0.2)
plt.title(title_2, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.legend(loc="upper left")

# Super Title
plt.suptitle(title_main, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("line_123.pdf", bbox_inches="tight")
