
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for tourism domain
years = np.array([2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022])
tourists_country_a = np.array([2.5, 3.0, 3.7, 4.1, 4.8, 2.5, 3.0, 4.2])  # in millions
tourists_country_b = np.array([1.8, 2.2, 2.6, 3.0, 3.5, 1.8, 2.3, 3.8])  # in millions

# Labels and titles
xlabel_value = "Years"
ylabel_value = "Tourist Arrivals (in millions)"
label_1 = "Country A"
label_2 = "Country B"
title_1 = "Tourist Arrivals in Country A"
title_2 = "Tourist Arrivals in Country B"
suptitle_value = "Tourist Arrivals Over Recent Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 5))

# First subplot
plt.subplot(1, 2, 1)
plt.plot(
    years,
    tourists_country_a,
    marker="v",
    color="#2ca02c",  # green
    label=label_1,
    markerfacecolor="#2ca02c",
    linewidth=2,
    linestyle="--",
    markersize=6,
)
plt.fill_between(years, tourists_country_a - 0.3, tourists_country_a + 0.3, color="#2ca02c", alpha=0.2)
plt.title(title_1, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)

# Second subplot
plt.subplot(1, 2, 2)
plt.plot(
    years,
    tourists_country_b,
    marker="s",
    color="#ff7f0e",  # orange
    label=label_2,
    markerfacecolor="#ff7f0e",
    linewidth=2,
    linestyle="-.",
    markersize=6,
)
plt.fill_between(years, tourists_country_b - 0.2, tourists_country_b + 0.2, color="#ff7f0e", alpha=0.2)
plt.title(title_2, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.legend(loc="upper left", frameon=True)

# Add a super title for the whole figure
plt.suptitle(suptitle_value, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust the layout to make room for suptitle
plt.savefig("line_124.pdf", bbox_inches="tight")
