
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for plotting
years = np.array([2000, 2005, 2010, 2015, 2020, 2025])
north_america = np.array([45, 55, 65, 75, 85, 90])
europe = np.array([30, 45, 60, 70, 80, 85])
asia = np.array([10, 20, 40, 50, 60, 70])

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1995, 2030]

ylabel_value = "Internet Penetration Rate (%)"
ylim_values = [0, 100]
yticks_values = np.arange(0, 101, 10)

# Labels
label_NA = "North America"
label_EU = "Europe"
label_AS = "Asia"

title="Global Internet Penetration Rates Over Years"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(7, 5))  # Adjusting figure size for better visibility
plt.plot(
    years, north_america, "o--", color="#1f77b4", label=label_NA, linewidth=2, markersize=8
)
plt.plot(years, europe, "s-", color="#ff7f0e", label=label_EU, linewidth=2, markersize=8)
plt.plot(years, asia, "D-.", color="#2ca02c", label=label_AS, linewidth=2, markersize=8)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Set x-axis fontsize
plt.xticks(years, fontsize=14)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18)

# Adding grid
plt.grid(True, which="both", ls="--", linewidth=0.5)

# Adding legend, show it horizontally and place it at the lower right corner
plt.legend(loc="lower right", fontsize=12, ncol=3, columnspacing=1, edgecolor="black")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_125.pdf", bbox_inches="tight")
