
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
years = np.array([2000, 2005, 2010, 2015, 2020])
region_a_emissions = np.array([5.2, 5.8, 6.0, 6.5, 7.0])
region_b_emissions = np.array([4.1, 4.3, 4.5, 4.8, 5.1])
region_c_emissions = np.array([3.0, 3.2, 3.5, 3.8, 4.0])

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1999, 2021]

ylabel_value = "CO2 Emissions (in billion tons)"
ylim_values = [2.5, 7.5]
yticks_values = np.arange(3, 8, 1)

# Labels
label_Region_A = "Region A"
label_Region_B = "Region B"
label_Region_C = "Region C"
title="CO2 Emissions Over Time by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 6))  # Adjusted figure size to be larger for better visibility
plt.plot(
    years, region_a_emissions, "o-", color="#1f77b4", linewidth=2, markersize=6, label=label_Region_A
)
plt.plot(
    years, region_b_emissions, "s--", color="#ff7f0e", linewidth=2, markersize=6, label=label_Region_B
)
plt.plot(
    years, region_c_emissions, "d:", color="#2ca02c", linewidth=2, markersize=6, label=label_Region_C
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Set x-axis limits and fontsize
plt.xlim(xlim_values)
plt.xticks(years, fontsize=14)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18)

# Adding grid
plt.grid(True, which="both", ls="--", linewidth=0.7)

# Adding legend, show it horizontally and place it at the upper left corner
plt.legend(loc="upper left", fontsize=12, ncol=1, columnspacing=0.5, edgecolor="black")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_127.pdf", bbox_inches="tight")
