
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define subplot titles
titles = [
    "MedA with Supplement",
    "MedA without Supplement",
    "MedB with Supplement",
    "MedB without Supplement",
]

# Generate sample health data
days = np.linspace(0, 40, 5)
medA_with_supp = np.linspace(70, 85, len(days)) + np.random.uniform(-2, 2, len(days))
medA_without_supp = np.linspace(70, 80, len(days)) + np.random.uniform(-3, 3, len(days))
medB_with_supp = np.linspace(65, 83, len(days)) + np.random.uniform(-2, 2, len(days))
medB_without_supp = np.linspace(65, 78, len(days)) + np.random.uniform(-3, 3, len(days))

# Error for sample data
error_A = np.random.uniform(1, 3, len(days))
error_B = np.random.uniform(1, 3, len(days))

# Axes Limits and Labels
xlabel_value = "Days"
ylabel_value = "Health Score"

# Labels
label_1 = "MedA with Supplement"
label_2 = "MedA without Supplement"
label_3 = "MedB with Supplement"
label_4 = "MedB without Supplement"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
plt.figure(figsize=(16, 8))

# Custom colors
color_A = "#2ca02c"  # Calming green
color_B = "#1f77b4"  # Calming blue

# Loop through each subplot
for i in range(4):
    plt.subplot(2, 2, i + 1)
    
    if i == 0:
        plt.plot(days, medA_with_supp, "-o", label=label_1, color=color_A)
        plt.fill_between(
            days,
            medA_with_supp - error_A,
            medA_with_supp + error_A,
            color=color_A,
            alpha=0.2,
        )
    elif i == 1:
        plt.plot(days, medA_without_supp, "-o", label=label_2, color=color_A)
        plt.fill_between(
            days,
            medA_without_supp - error_A,
            medA_without_supp + error_A,
            color=color_A,
            alpha=0.2,
        )
    elif i == 2:
        plt.plot(days, medB_with_supp, "--s", label=label_3, color=color_B)
        plt.fill_between(
            days,
            medB_with_supp - error_B,
            medB_with_supp + error_B,
            color=color_B,
            alpha=0.2,
        )
    elif i == 3:
        plt.plot(days, medB_without_supp, "--s", label=label_4, color=color_B)
        plt.fill_between(
            days,
            medB_without_supp - error_B,
            medB_without_supp + error_B,
            color=color_B,
            alpha=0.2,
        )

    plt.title(titles[i])
    plt.xlabel(xlabel_value)
    plt.ylabel(ylabel_value)
    plt.legend(loc="upper left")
    plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Show the plot
plt.savefig("line_129.pdf", bbox_inches="tight")
