
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)  # For reproducibility

# Define subplot titles (datasets)
titles = [
    "Text8",
    "Wikipedia",
    "Twitter",
    "BooksCorpus"
]

# Generate sample data (performance trends across ratios)
ratios = np.linspace(0.1, 1.0, 5)
performance_bert = np.random.uniform(0.85, 0.95, len(ratios))
performance_gpt3 = np.random.uniform(0.80, 0.90, len(ratios))
performance_lstm = np.random.uniform(0.75, 0.85, len(ratios))

# Error margins
error_bert = np.random.uniform(0.01, 0.02, len(ratios))
error_gpt3 = np.random.uniform(0.015, 0.025, len(ratios))
error_lstm = np.random.uniform(0.02, 0.03, len(ratios))

# Axes Limits and Labels
xlabel_value = "Sample Size Ratio"
ylabel_value = "Model Performance (Accuracy)"

# Labels
label_bert = "BERT"
label_gpt3 = "GPT-3"
label_lstm = "LSTM"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(16, 8))

# Define color palette
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

for i in range(4):
    plt.subplot(2, 2, i + 1)
    plt.plot(ratios, performance_bert, "-o", label=label_bert, color=colors[0], linewidth=2)
    plt.fill_between(ratios, performance_bert - error_bert, performance_bert + error_bert, color=colors[0], alpha=0.2)
    
    plt.plot(ratios, performance_gpt3, "-s", label=label_gpt3, color=colors[1], linewidth=2)
    plt.fill_between(ratios, performance_gpt3 - error_gpt3, performance_gpt3 + error_gpt3, color=colors[1], alpha=0.2)
    
    plt.plot(ratios, performance_lstm, "-^", label=label_lstm, color=colors[2], linewidth=2)
    plt.fill_between(ratios, performance_lstm - error_lstm, performance_lstm + error_lstm, color=colors[2], alpha=0.2)
    
    plt.title(titles[i], fontsize=14)
    plt.xlabel(xlabel_value, fontsize=12)
    plt.ylabel(ylabel_value, fontsize=12)
    plt.legend(loc="lower right", fontsize=10)
    plt.grid(True)

# Adjust layout for better spacing
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_130.pdf", bbox_inches="tight")
