
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)
x = [10, 15, 20, 25, 30, 35, 40]
y = [2.5, 2.8, 3.0, 3.2, 3.5, 3.8, 4.0]
categories = [
    "Below Average",
    "Average",
    "Above Average",
    "Good",
    "Very Good",
    "Excellent",
    "Outstanding",
] 

# Axes Limits and Labels
xlabel_value = "Study Hours Per Week"
xlim_values = [5, 45]
xticks_values = np.arange(10, 41, 5)

ylabel_value = "Average GPA"
ylim_values = [2.0, 4.5]
yticks_values = np.arange(2.0, 4.5, 0.5)

# Labels
label_data = "Study Hours vs. GPA"
comparison_1 = "Minimum Passing GPA: 2.0"
comparison_2 = "Average GPA: 3.0"
comparison_3 = "Excellent GPA: 3.5"
comparison_4 = "Perfect GPA: 4.0"

title = "Impact of Study Hours on GPA"
subtitle = "An overview of how study hours affect student performance"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(6, 5))

# Plot the line
ax.plot(x, y, marker="o", color="#1f77b4", label=label_data, linestyle='-', linewidth=2, markersize=8)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=10)
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Annotate the points with categories
for i, txt in enumerate(categories):
    ax.annotate(txt, (x[i], y[i]), textcoords="offset points", xytext=(0, 10), ha="center")

# Horizontal lines for comparison
ax.axhline(y=2.0, color="red", linestyle="--", label=comparison_1)
ax.axhline(y=3.0, color="orange", linestyle="--", label=comparison_2)
ax.axhline(y=3.5, color="green", linestyle="--", label=comparison_3)
ax.axhline(y=4.0, color="blue", linestyle="--", label=comparison_4)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')
fig.suptitle(subtitle, fontsize=10, fontweight='light', y=0.95)

# Set the legend
ax.legend(loc="lower right", fontsize=10)

# Set grid
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_134.pdf", bbox_inches="tight")
