
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
np.random.seed(0)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul"]
stock_prices = [100, 110, 105, 115, 120, 125, 130]
annotations = [
    "Initial",
    "Growth",
    "Slight Decline",
    "Recovery",
    "Peak",
    "Stable",
    "Slight Growth",
]

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [0, 6]
xticks_values = np.arange(0, 7, 1)
xlabel_ticks = months

ylabel_value = "Stock Prices (USD)"
ylim_values = [95, 135]
yticks_values = np.arange(95, 136, 5)

# Labels
label_1 = "Stock A"
label_2 = "Industry Average: 115"
label_3 = "Previous Year Max: 125"
label_4 = "Previous Year Min: 100"
label_5 = "Analyst Target: 130"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(6, 4))

# Plot the line
ax.plot(stock_prices, marker="o", color="#1f77b4", label=label_1)

# Set x,y-axis with specific ticks and labels
plt.yticks(yticks_values, fontsize=10)
plt.xticks(xticks_values, labels=xlabel_ticks, fontsize=10)
plt.xlim(xlim_values)  # Adjust x-axis limit

# Annotate the points with bit values
for i, txt in enumerate(annotations):
    ax.annotate(
        txt, (i, stock_prices[i]), textcoords="offset points", xytext=(0, 10), ha="center"
    )

# Horizontal lines for comparison
ax.axhline(y=115, color="magenta", linestyle="--", label=label_2)
ax.axhline(y=125, color="orange", linestyle="--", label=label_3)
ax.axhline(y=100, color="green", linestyle="--", label=label_4)
ax.axhline(y=130, color="red", linestyle="--", label=label_5)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylim(ylim_values)  # Adjust y-axis limit
ax.set_xlim(xlim_values)  # Adjust x-axis limit
ax.set_ylabel(ylabel_value, fontsize=12)

# Set the legend
ax.legend(loc="upper left", fontsize=10)

# Set grid
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_135.pdf", bbox_inches="tight")
