
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for Energy Consumption
months = np.arange(1, 13, 1)
average_energy = np.array([200, 215, 210, 220, 230, 235, 240, 225, 210, 205, 190, 195])
std_dev_energy = np.array([15, 18, 16, 20, 22, 24, 17, 15, 14, 13, 19, 21])

# Axes Limits and Labels
xlabel_value = "Month"
ylabel_value = "Energy Consumption (kWh)"
ylim_values = [150, 275]
yticks_values = np.arange(150, 276, 25)

# Labels
label_Average = "Average Energy"
label_Standard_Deviation = "Standard Deviation"

# Title
title_value = "Monthly Energy Consumption in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the average line
plt.figure(figsize=(8, 5))
plt.plot(months, average_energy, label=label_Average, marker="o", color="#2ca02c", linestyle='-', linewidth=2)

# Plotting the standard deviation as a shaded area
plt.fill_between(
    months,
    average_energy - std_dev_energy,
    average_energy + std_dev_energy,
    color="#2ca02c",
    alpha=0.3,
    label=label_Standard_Deviation,
)

# Adjusting y-axis range
plt.ylim(ylim_values)

# Adding yticks
plt.yticks(yticks_values)

# Adding labels and title with defined font size
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title_value, fontsize=14, fontweight='bold')

# Adding legend with no border
plt.legend(frameon=True, fontsize=11)

# Adding grid
plt.grid(True, color="#e4e4e4")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout
plt.tight_layout()
plt.savefig("line_140.pdf", bbox_inches="tight")
