
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data: Media consumption trends
weeks = np.arange(1, 11, 1)
average_tv = np.array([20, 19, 18, 16, 15, 14, 13, 12, 11, 10])
average_streaming = np.array([5, 6, 7, 8, 9, 10, 11, 12, 13, 14])
std_dev_tv = np.array([2, 2, 2, 2, 2, 2, 2, 2, 2, 2])
std_dev_streaming = np.array([1, 1, 1, 1, 1, 1, 1, 1, 1, 1])

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Hours per Week"
ylim_values = [0, 25]
yticks_values = np.arange(0, 26, 5)

# Labels
label_TV = "Traditional TV"
label_Streaming = "Streaming Services"
title="Weekly Media Consumption Trends"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 5))

# Plotting TV consumption
plt.plot(weeks, average_tv, label=label_TV, marker="s", linestyle="--", color="#ff7f0e", linewidth=2, markersize=6)
plt.fill_between(
    weeks,
    average_tv - std_dev_tv,
    average_tv + std_dev_tv,
    color="#ff7f0e",
    alpha=0.2,
)

# Plotting Streaming consumption
plt.plot(weeks, average_streaming, label=label_Streaming, marker="^", linestyle="-", color="#2ca02c", linewidth=2, markersize=6)
plt.fill_between(
    weeks,
    average_streaming - std_dev_streaming,
    average_streaming + std_dev_streaming,
    color="#2ca02c",
    alpha=0.2,
)

# Adjusting y-axis range and ticks
plt.ylim(ylim_values)
plt.yticks(yticks_values)

# Adding labels and title with enhanced font size
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=14)

# Adding legend
plt.legend(frameon=True, fontsize=12)

# Adding grid
plt.grid(True, color="#d1d1d1", linestyle=":")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_141.pdf", bbox_inches="tight")
