
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)  # Ensures reproducibility

# Sample Data: Annual average temperature anomalies and their standard deviations over a decade
years = np.arange(2010, 2020, 1)
temperature_anomalies = np.array([0.55, 0.6, 0.62, 0.65, 0.68, 0.7, 0.72, 0.75, 0.78, 0.8])
std_dev = np.array([0.05, 0.06, 0.04, 0.05, 0.06, 0.04, 0.05, 0.06, 0.04, 0.05])

# Axes Limits and Labels
xlabel_value = "Years"
ylabel_value = "Temperature Anomalies (°C)"
ylim_values = [0.4, 0.85]
yticks_values = np.arange(0.4, 0.85, 0.05)

# Labels
label_Average = "Average Temperature Anomalies"
label_Standard_Deviation = "Standard Deviation"
suptitle="Annual Temperature Anomalies (2010-2019)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the average line
plt.figure(figsize=(8, 5))
plt.plot(years, temperature_anomalies, label=label_Average, marker="^", linestyle="--", color="#FF5733")

# Plotting the standard deviation as a shaded area
plt.fill_between(
    years,
    temperature_anomalies - std_dev,
    temperature_anomalies + std_dev,
    color="#FF5733",
    alpha=0.2,
    label=label_Standard_Deviation,
)

# Adjusting y-axis range to match the reference picture
plt.ylim(ylim_values)

# Adding yticks
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Adding labels and title with smaller font size
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.suptitle(suptitle, fontsize=14)

# Adding legend with no border
plt.legend(frameon=True, fontsize=10)

# Adding grid
plt.grid(True, color="#e0e0e0", linestyle='--', linewidth=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_142.pdf", bbox_inches="tight")
