
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seasons
seasons = np.array([1, 2, 3, 4])
season_labels = ['Spring', 'Summer', 'Fall', 'Winter']

# Pollution Measurements for Three Sensors
sensor_a = np.array([30, 35, 25, 20])
sensor_b = np.array([28, 33, 24, 19])
sensor_c = np.array([32, 37, 29, 22])

# Error
error = np.array([1, 1, 1, 1])

# Axes Limits and Labels
ylabel_value_1 = "Pollution Level (µg/m³)"
ylabel_value_2 = "Pollution Level (µg/m³)"
ylim_values_1 = [15, 40]
yticks_values_1 = [20, 25, 30, 35, 40]
ylim_values_2 = [15, 40]
yticks_values_2 = [20, 25, 30, 35, 40]

# Labels
label_Sensor_A = "Sensor A"
label_Sensor_B = "Sensor B"
label_Sensor_C = "Sensor C"

# Texts
text_1 = "Seasons"
text_2 = "Average Pollution Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create two subplots and unpack the output array immediately
f, (ax1, ax2) = plt.subplots(2, 1, sharex=True, figsize=(8, 6))

# First subplot
ax1.errorbar(
    seasons,
    sensor_a,
    yerr=error,
    label=label_Sensor_A,
    color="#2ca02c",
    marker="o",
    linestyle='--',
)
ax1.errorbar(
    seasons,
    sensor_b,
    yerr=error,
    label=label_Sensor_B,
    color="#1f77b4",
    marker="s",
    linestyle='-',
)
ax1.errorbar(
    seasons,
    sensor_c,
    yerr=error,
    label=label_Sensor_C,
    color="#8c564b",
    marker="^",
    linestyle=':',
)
ax1.set_ylabel(ylabel_value_1)
# Set grid
ax1.grid(True)
ax1.set_ylim(ylim_values_1)
ax1.set_yticks(yticks_values_1)

# Second subplot
ax2.errorbar(
    seasons,
    sensor_a,
    yerr=error,
    label=label_Sensor_A,
    color="#2ca02c",
    marker="o",
    linestyle='--',
)
ax2.errorbar(
    seasons,
    sensor_b,
    yerr=error,
    label=label_Sensor_B,
    color="#1f77b4",
    marker="s",
    linestyle='-',
)
ax2.errorbar(
    seasons,
    sensor_c,
    yerr=error,
    label=label_Sensor_C,
    color="#8c564b",
    marker="^",
    linestyle=':',
)
ax2.set_ylabel(ylabel_value_2)
# Set grid
ax2.grid(True)
ax2.set_ylim(ylim_values_2)
ax2.set_yticks(yticks_values_2)

# Only show ticks on the bottom subplot
plt.setp(ax1.get_xticklabels(), visible=False)

# Create legend above the second subplot
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

# Set the figure's layout so there is space for the xlabel at the bottom
plt.tight_layout()

# Now adjust the subplot to give space for the ylabel on the left
f.subplots_adjust(left=0.15, bottom=0.12)

ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

# Add horizontal line at y=30 for reference
for ax in [ax1, ax2]:
    ax.axhline(y=30, color='gray', linestyle='--', linewidth=1, alpha=0.7)
    # Add annotation for the horizontal line
    ax.annotate('Threshold Level', xy=(0.02, 30), xytext=(0.02, 31),
                arrowprops=dict(facecolor='black', shrink=0.05))

f.text(0.55, 0.05, text_1, ha="center", va="center")
f.text(
    0.05,
    0.5,
    text_2,
    ha="center",
    va="center",
    rotation="vertical",
)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_143.pdf", bbox_inches="tight")
