
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Dummy data for the purpose of plotting. In a real scenario, you would use your actual data.
age_groups = np.array([10, 15, 20, 25])

# Average Performance Scores for Event A
athlete1_eventA = np.array([8, 8.2, 8.4, 8.6])
athlete2_eventA = np.array([7.5, 7.7, 8, 8.2])
athlete3_eventA = np.array([7, 7.3, 7.6, 7.9])

# Error for Event A
error_eventA = np.array([0.1, 0.1, 0.1, 0.1])

# Average Performance Scores for Event B
athlete1_eventB = np.array([7.5, 8, 8.5, 9])
athlete2_eventB = np.array([6.8, 7.3, 7.8, 8.3])
athlete3_eventB = np.array([6, 6.5, 7, 7.5])

# Error for Event B
error_eventB = np.array([0.2, 0.2, 0.2, 0.2])

# Axes Limits and Labels
ylabel_eventA = "Event A Performance"
ylabel_eventB = "Event B Performance"
ylim_eventA = [6.5, 9.0]
yticks_eventA = [7.0, 7.5, 8.0, 8.5, 9.0]
ylim_eventB = [5.5, 9.5]
yticks_eventB = [6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0]

# Labels
label_Athlete1 = "Athlete 1"
label_Athlete2 = "Athlete 2"
label_Athlete3 = "Athlete 3"

# Texts
xlabel = "Age Group"
ylabel_combined = "Average Performance Score"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create two subplots and unpack the output array immediately
f, (ax1, ax2) = plt.subplots(2, 1, sharex=True, figsize=(8, 6))

# First subplot for Event A
ax1.errorbar(
    age_groups,
    athlete1_eventA,
    yerr=error_eventA,
    label=label_Athlete1,
    color="#1f77b4",
    marker="o",
    linestyle='-', 
    linewidth=2
)
ax1.errorbar(
    age_groups,
    athlete2_eventA,
    yerr=error_eventA,
    label=label_Athlete2,
    color="#ff7f0e",
    marker="s",
    linestyle='--', 
    linewidth=2
)
ax1.errorbar(
    age_groups,
    athlete3_eventA,
    yerr=error_eventA,
    label=label_Athlete3,
    color="#2ca02c",
    marker="^",
    linestyle=':', 
    linewidth=2
)
ax1.set_ylabel(ylabel_eventA)
# Set grid
ax1.grid(True)
ax1.set_ylim(ylim_eventA)
ax1.set_yticks(yticks_eventA)

# Second subplot for Event B
ax2.errorbar(
    age_groups,
    athlete1_eventB,
    yerr=error_eventB,
    label=label_Athlete1,
    color="#1f77b4",
    marker="o",
    linestyle='-', 
    linewidth=2
)
ax2.errorbar(
    age_groups,
    athlete2_eventB,
    yerr=error_eventB,
    label=label_Athlete2,
    color="#ff7f0e",
    marker="s",
    linestyle='--', 
    linewidth=2
)
ax2.errorbar(
    age_groups,
    athlete3_eventB,
    yerr=error_eventB,
    label=label_Athlete3,
    color="#2ca02c",
    marker="^",
    linestyle=':', 
    linewidth=2
)
ax2.set_ylabel(ylabel_eventB)
# Set grid
ax2.grid(True)
ax2.set_ylim(ylim_eventB)
ax2.set_yticks(yticks_eventB)

# Only show ticks on the bottom subplot
plt.setp(ax1.get_xticklabels(), visible=False)

# Create legend above the second subplot
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

# Set the figure's layout so there is space for the xlabel at the bottom
plt.tight_layout()

# Now adjust the subplot to give space for the ylabel on the left
f.subplots_adjust(left=0.15, bottom=0.12)

# Place the legend and adjust subplot parameters
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

f.text(0.55, 0.05, xlabel, ha="center", va="center")
f.text(
    0.05,
    0.5,
    ylabel_combined,
    ha="center",
    va="center",
    rotation="vertical",
)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_144.pdf", bbox_inches="tight")
