
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Dummy data for the purpose of plotting. In a real scenario, you would use your actual data.
age_groups = np.array([20, 40, 60, 80])

# Cognitive Function Scores
baseline_cognitive = np.array([90, 85, 75, 60])
treatment_a_cognitive = np.array([88, 84, 78, 65])
treatment_b_cognitive = np.array([85, 80, 70, 58])

# Error
error_cognitive = np.array([2, 2, 3, 4])

# Axes Limits and Labels
ylabel_value_1 = "Cognitive Function Score"
ylabel_value_2 = "Memory Retention Score"
ylim_values_1 = [50, 100]
yticks_values_1 = [60, 70, 80, 90, 100]
ylim_values_2 = [40, 90]
yticks_values_2 = [50, 60, 70, 80]

# Memory Retention Scores
baseline_memory = np.array([85, 80, 70, 55])
treatment_a_memory = np.array([86, 82, 75, 60])
treatment_b_memory = np.array([84, 78, 72, 58])

# Error
error_memory = np.array([1.5, 1.5, 1.8, 2])

# Labels
label_Baseline = "Baseline"
label_Treatment_A = "Treatment A"
label_Treatment_B = "Treatment B"

# Texts
text_1 = "Age Group"
text_2 = "Scores"
title=["Cognitive Function Analysis","Memory Retention Analysis",]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create two subplots and unpack the output array immediately
f, (ax1, ax2) = plt.subplots(2, 1, sharex=True, figsize=(10, 8))

# First subplot for Cognitive Function Score
ax1.errorbar(
    age_groups,
    baseline_cognitive,
    yerr=error_cognitive,
    label=label_Baseline,
    color="#ff9999",
    linestyle="--",
    linewidth=2,
    marker="o",
    markersize=8,
)
ax1.errorbar(
    age_groups,
    treatment_a_cognitive,
    yerr=error_cognitive,
    label=label_Treatment_A,
    color="#66b3ff",
    linestyle="-.",
    linewidth=2,
    marker="s",
    markersize=8,
)
ax1.errorbar(
    age_groups,
    treatment_b_cognitive,
    yerr=error_cognitive,
    label=label_Treatment_B,
    color="#99ff99",
    linestyle=":",
    linewidth=2,
    marker="^",
    markersize=8,
)
ax1.set_ylabel(ylabel_value_1)
ax1.set_title(title[0])
# Set grid
ax1.grid(True)
ax1.set_ylim(ylim_values_1)
ax1.set_yticks(yticks_values_1)

# Second subplot for Memory Retention Score
ax2.errorbar(
    age_groups,
    baseline_memory,
    yerr=error_memory,
    label=label_Baseline,
    color="#ff9999",
    linestyle="--",
    linewidth=2,
    marker="o",
    markersize=8,
)
ax2.errorbar(
    age_groups,
    treatment_a_memory,
    yerr=error_memory,
    label=label_Treatment_A,
    color="#66b3ff",
    linestyle="-.",
    linewidth=2,
    marker="s",
    markersize=8,
)
ax2.errorbar(
    age_groups,
    treatment_b_memory,
    yerr=error_memory,
    label=label_Treatment_B,
    color="#99ff99",
    linestyle=":",
    linewidth=2,
    marker="^",
    markersize=8,
)
ax2.set_ylabel(ylabel_value_2)
ax2.set_title(title[1])
# Set grid
ax2.grid(True)
ax2.set_ylim(ylim_values_2)
ax2.set_yticks(yticks_values_2)

# Only show ticks on the bottom subplot
plt.setp(ax1.get_xticklabels(), visible=False)

# Create legend above the second subplot
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

# Set the figure's layout so there is space for the xlabel at the bottom
plt.tight_layout()

# Now adjust the subplot to give space for the ylabel on the left
f.subplots_adjust(left=0.15, bottom=0.12)

# Place the legend and adjust subplot parameters
ax2.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=3)

f.text(0.55, 0.05, text_1, ha="center", va="center")
f.text(
    0.05,
    0.5,
    text_2,
    ha="center",
    va="center",
    rotation="vertical",
)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_145.pdf", bbox_inches="tight")
