
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
years_experience = ["1", "2", "3", "4", "5", "6", "7"]
public_defender = [0.4, 0.45, 0.5, 0.55, 0.6, 0.62, 0.65]
private_attorney = [0.6, 0.68, 0.72, 0.76, 0.8, 0.82, 0.85]
corporate_lawyer = [0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.78]

# Variables for plot configuration
line_labels = ["Public Defender", "Private Attorney", "Corporate Lawyer"]
xlim_values = (0, len(years_experience) - 1)
ylim_values = (0.3, 0.9)
xlabel_value = "Years of Experience"
ylabel_value = "Case Success Rate"
xticks_values = range(len(years_experience))
yticks_values = np.arange(0.3, 1.0, 0.1)
xtickslabel_values = years_experience
ytickslabel_values = None
title_value = "Attorney Case Success Rate Over Years of Experience"
axhline_value = None
axvline_value = None

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(10, 7))
plt.plot(
    years_experience,
    public_defender,
    "s--",
    clip_on=False,
    zorder=10,
    color="#1f77b4",  # Dark blue
    label=line_labels[0],
    linewidth=2,
)
plt.plot(
    years_experience,
    private_attorney,
    "^--",
    clip_on=False,
    zorder=10,
    color="#2ca02c",  # Dark green
    label=line_labels[1],
    linewidth=2,
)
plt.plot(
    years_experience,
    corporate_lawyer,
    "o--",
    clip_on=False,
    zorder=10,
    color="#d62728",  # Dark red
    label=line_labels[2],
    linewidth=2,
)

# Setting x and y ticks
plt.xticks(xticks_values, xtickslabel_values, fontsize=14)
plt.xlim(xlim_values)
plt.yticks(yticks_values, fontsize=14)

# Adding minor y-axis ticks with a step of 0.05
ax = plt.gca()
ax.yaxis.set_minor_locator(MultipleLocator(0.05))

# Adjust tick parameters
ax.tick_params(axis="both", which="both", length=5, color="gray")  # Move ticks inside
ax.tick_params(
    axis="y", which="minor", length=3  # Adjusting minor tick length for better visibility
)

# Title and labels
plt.title(title_value, fontsize=16)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# Enable gridlines for major and minor ticks
plt.grid(True, color="#b0b0b0", which="both", linestyle="-", linewidth=0.5)

# Legend with serif font family
plt.legend(
    frameon=False, fontsize=12, loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3
)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()

plt.savefig("line_148.pdf", bbox_inches="tight")
