
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
years = [2010, 2012, 2014, 2016, 2018, 2020]
program_a_success_rate = [55.0, 60.2, 68.4, 75.0, 80.5, 85.0]
program_b_success_rate = [45.9, 50.7, 58.6, 65.8, 72.0, 78.4]
program_c_success_rate = [35.8, 40.0, 48.8, 55.6, 62.0, 68.6]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [2008, 2022]
xticks_values = [2010, 2012, 2014, 2016, 2018, 2020]
xticklabels = ["2010", "2012", "2014", "2016", "2018", "2020"]

ylabel_value = "Success Rate (%)"

# Labels
label_program_A = "Program A"
label_program_B = "Program B"
label_program_C = "Program C"

title = 'Health Program Success Rates Over Time'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years, program_a_success_rate, "o-", label=label_program_A, color="#2C7BB6", linestyle='-', linewidth=2, markersize=6
)
plt.plot(
    years, program_b_success_rate, "s-", label=label_program_B, color="#ABD9E9", linestyle='--', linewidth=2, markersize=6
)
plt.plot(
    years, program_c_success_rate, "^-", label=label_program_C, color="#FDAE61", linestyle='-.', linewidth=2, markersize=6
)

# Set x-axis ticks and limits
plt.xticks(xticks_values, xticklabels)
plt.xlim(xlim_values)

# Adding data labels
for i, txt in enumerate(program_a_success_rate):
    plt.annotate(
        txt,
        (years[i], program_a_success_rate[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(program_b_success_rate):
    plt.annotate(
        txt,
        (years[i], program_b_success_rate[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(program_c_success_rate):
    plt.annotate(
        txt,
        (years[i], program_c_success_rate[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )

# Setting the axis labels and title
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title, fontsize=16)

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#cccccc")
ax.spines["bottom"].set_linewidth(1.4)
ax.spines["left"].set_color("#cccccc")
ax.spines["left"].set_linewidth(1.4)
ax.spines["top"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")

# Adjust tick parameters to ensure ticks do not extend outside
ax.tick_params(axis="both", which="both", length=0)  # Hide tick marks

# Adding the legend
plt.legend(loc="lower right")

# Adding grid
plt.grid(True, which="both", linestyle="--", linewidth=1, color="#808080")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_149.pdf", bbox_inches="tight")
