
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
years = [2000, 2005, 2010, 2015]
fiction_ratings = [3.5, 4.0, 4.2, 4.4]
nonfiction_ratings = [3.0, 3.5, 3.6, 3.8]
fantasy_ratings = [4.0, 4.2, 4.5, 4.7]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1998, 2017]
xticks_values = [2000, 2005, 2010, 2015]
xticklabels = ["2000", "2005", "2010", "2015"]

ylabel_value = "Average Book Ratings"

# Labels
label_Fiction = "Fiction"
label_Nonfiction = "Non-Fiction"
label_Fantasy = "Fantasy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years, fiction_ratings, "o-", label=label_Fiction, color="#ffb6b9", linestyle="--", linewidth=2, markersize=8
)
plt.plot(
    years, nonfiction_ratings, "x-", label=label_Nonfiction, color="#8ac6d1", linestyle="-.", linewidth=2, markersize=8
)
plt.plot(
    years, fantasy_ratings, "s-", label=label_Fantasy, color="#ff8b94", linestyle="-", linewidth=2, markersize=8
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, xticklabels)
plt.xlim(xlim_values) 

# Adding data labels
for i, txt in enumerate(fiction_ratings):
    plt.annotate(
        txt,
        (years[i], fiction_ratings[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=12,
    )
for i, txt in enumerate(nonfiction_ratings):
    plt.annotate(
        txt,
        (years[i], nonfiction_ratings[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=12,
    )
for i, txt in enumerate(fantasy_ratings):
    plt.annotate(
        txt,
        (years[i], fantasy_ratings[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=12,
    )

# Setting the axis labels
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#cccccc")
ax.spines["bottom"].set_linewidth(1.4)
ax.spines["left"].set_color("#cccccc")
ax.spines["left"].set_linewidth(1.4)
ax.spines["top"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")

# Adjust tick parameters to ensure ticks do not extend outside
ax.tick_params(axis="both", which="both", length=0)  # Hide tick marks

# Adding the legend
plt.legend(loc="upper left")

# Adding grid
plt.grid(True, which="both", linestyle="--", linewidth=1, color="#808080")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_151.pdf", bbox_inches="tight")
