
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
x = [10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
protocol_a_y = [15, 13, 12, 11, 9, 8, 7, 6, 5, 4]    # Latency in ms
protocol_b_y = [20, 18, 16, 15, 13, 12, 11, 10, 9, 8]
industry_standard_y = 10

# Axes Limits and Labels
xlabel_value = "Number of messages per second"
ylabel_value = "Latency (ms)"
xlim_values = [0, 110]
ylim_values = [0, 25]
xticks_values = np.arange(10, 101, 10)
yticks_values = np.arange(0, 26, 5)

# Labels
label_1 = "Protocol A"
label_2 = "Protocol B"
label_3 = "Industry Standard Latency"

title="Performance Comparison of Communication Protocols"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 5))

# Line charts
ax.plot(x, protocol_a_y, marker="o", color="#2ca02c", label=label_1, linestyle='-', linewidth=2)
ax.plot(x, protocol_b_y, marker="^", color="#ff7f0e", label=label_2, linestyle='--', linewidth=2)

# Set x,y-axis to display specific ticks
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Horizontal dashed line for industry standard
ax.axhline(y=industry_standard_y, color="purple", linestyle=":", label=label_3, linewidth=2)

# Title and Legend
ax.set_title(title, fontsize=14)
ax.legend(loc="upper right")

# Labels
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_153.pdf", bbox_inches="tight")
