
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
days = range(1, 21)
region1_temp = np.array([21 + 0.5 * i + np.random.uniform(-0.5, 0.5) for i in days])
region2_temp = np.array([15 + 0.3 * i + np.random.uniform(-0.3, 0.3) for i in days])

# Axes Limits and Labels
xlabel_value = "Days"
xlim_values = [0, 21]
xticks_values = [0, 5, 10, 15, 20]

ylabel_value = "Avg. Temperature (°C)"
ylim_values = [10, 35]

# Labels
label_1 = "Region 1"
label_2 = "Region 2"
title_value = "Average Temperature Over 20 Days"
legend_labels = [label_1, label_2]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(6, 4))
plt.plot(days, region1_temp, "o--", label=label_1, color="#1f77b4", linewidth=2, markersize=6)
plt.plot(days, region2_temp, "s-", label=label_2, color="#ff7f0e", linewidth=2, markersize=6)

# Adding title and legend
plt.title(title_value)
plt.legend()

# Labeling axes
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xlim(xlim_values)
plt.xticks(xticks_values)

# Adding grid for better readability
plt.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_156.pdf", bbox_inches="tight")
