
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generate new data for a finance domain
months = range(1, 21)
strategy_a_returns = np.cumsum(np.random.normal(2, 0.5, 20))
strategy_b_returns = np.cumsum(np.random.normal(2.5, 1.5, 20))

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [0, 21]
xticks_values = [0, 5, 10, 15, 20]

ylabel_value = "Cumulative Returns (%)"
ylim_values = [strategy_a_returns.min()-5, strategy_b_returns.max()+5]

# Labels
label_1 = "Conservative Strategy (A)"
label_2 = "Aggressive Strategy (B)"
title="Performance of Investment Strategies Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(6, 4))
plt.plot(months, strategy_a_returns, "o-", label=label_1, color="#1f77b4")
plt.plot(months, strategy_b_returns, "s--", label=label_2, color="#ff7f0e")

# Adding legend
plt.legend()

# Labeling axes
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xlim(xlim_values)
plt.xticks(xticks_values)
plt.grid(True, linestyle='--', linewidth=0.5, color='gray')

# Adding plot title
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_157.pdf", bbox_inches="tight")
