
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New data for philosophical text analysis
text_length = np.arange(100, 401, 100)  # philosophical text lengths in words
bert_accuracy = [0.65, 0.70, 0.75, 0.80]
roberta_accuracy = [0.60, 0.65, 0.78, 0.82]
gpt3_accuracy = [0.68, 0.72, 0.76, 0.85]
transformer_accuracy = [0.62, 0.67, 0.73, 0.79]

# Placeholder error values
bert_error = np.random.uniform(0.01, 0.03, len(text_length))
roberta_error = np.random.uniform(0.01, 0.03, len(text_length))
gpt3_error = np.random.uniform(0.01, 0.03, len(text_length))
transformer_error = np.random.uniform(0.01, 0.03, len(text_length))

# Axes Limits and Labels
xlabel_value = "Text Length in Words"
ylabel_value = "Accuracy"
ylim_values = [0.55, 0.90]
yticks_values = np.arange(0.55, 0.91, 0.05)

# Labels
label_1 = "BERT Model"
label_2 = "RoBERTa Model"
label_3 = "GPT-3 Model"
label_4 = "Transformer Model"
title="Accuracy of Text Analysis Models on Philosophical Texts"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))

plt.errorbar(
    text_length,
    bert_accuracy,
    yerr=bert_error,
    fmt="-o",
    label=label_1,
    color="#4B8BBE",
    linestyle="--",
    linewidth=1.5,
    markersize=8,
)
plt.errorbar(
    text_length,
    roberta_accuracy,
    yerr=roberta_error,
    fmt="-s",
    label=label_2,
    color="#306998",
    linestyle="--",
    linewidth=1.5,
    markersize=8,
)
plt.errorbar(
    text_length,
    gpt3_accuracy,
    yerr=gpt3_error,
    fmt="-^",
    label=label_3,
    color="#FFD43B",
    linestyle="--",
    linewidth=1.5,
    markersize=8,
)
plt.errorbar(
    text_length,
    transformer_accuracy,
    yerr=transformer_error,
    fmt="-d",
    label=label_4,
    color="#646464",
    linestyle="--",
    linewidth=1.5,
    markersize=8,
)

# Adding labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(text_length)
plt.ylim(ylim_values)
plt.yticks(yticks_values)
plt.title(title)

# Adding legend, lower right corner
plt.legend(loc="lower right")

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["right"].set_color("none")
ax.spines["top"].set_color("none")
ax.grid(True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_161.pdf", bbox_inches="tight")
