
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Generate temperature data for 4 cities across 12 months
months = np.arange(1, 13)
city_a = [30, 32, 45, 50, 60, 70, 75, 74, 65, 55, 45, 35]
city_b = [20, 22, 35, 40, 50, 60, 65, 64, 55, 45, 35, 25]
city_c = [15, 18, 30, 35, 45, 55, 60, 62, 55, 45, 35, 20]
city_d = [10, 15, 25, 30, 40, 50, 55, 57, 50, 40, 30, 15]

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0.5, 12.5]
xticks_values = np.arange(1, 13, 1)

ylabel_value = "Average Temperature (°F)"
ylim_values = [0, 80]
yticks_values = np.arange(0, 81, 10)

# Labels
label_1 = "City A"
label_2 = "City B"
label_3 = "City C"
label_4 = "City D"
title="Average Monthly Temperature for Different Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(10, 6))  # Adjust the figure size
plt.plot(months, city_a, marker="o", linestyle="-", color="#FF5733", label=label_1, linewidth=2)
plt.plot(months, city_b, marker="s", linestyle="--", color="#33FF57", label=label_2, linewidth=2)
plt.plot(months, city_c, marker="^", linestyle="-.", color="#3357FF", label=label_3, linewidth=2)
plt.plot(months, city_d, marker="v", linestyle=":", color="#FF33A1", label=label_4, linewidth=2)

# Set x,y-axis properties
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)

# Add grid for better readability
plt.grid(True, linestyle="--", alpha=0.6)

# Add legend
plt.legend(loc="upper left", fontsize=12)

# Add labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_167.pdf", bbox_inches="tight")
