
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New sample data for economics domain
years = [2010, 2012, 2014, 2016, 2018, 2020]
gdp_growth = [2.5, 2.8, 3.0, 2.6, 2.9, 2.4]          # GDP growth in %
unemployment_rate = [9.6, 8.1, 6.2, 4.9, 3.9, 3.5]   # Unemployment rate in %
inflation_rate = [1.6, 1.7, 1.6, 1.3, 2.4, 1.2]      # Inflation rate in %
interest_rate = [0.25, 0.5, 0.75, 0.5, 1.5, 0.25]    # Interest rate in %

# Axes limits and labels
xlabel_value = "Year"
xlim_values = [2009, 2021]
xticks_values = np.arange(2010, 2021, 2)

ylabel_value = "Percentage"
ylim_values = [0, 10]
yticks_values = np.arange(0, 11, 1)

# Labels
label_gdp = "GDP Growth"
label_unemployment = "Unemployment Rate"
label_inflation = "Inflation Rate"
label_interest = "Interest Rate"
title="Economic Indicators Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 6))

# Style and plotting each line
plt.plot(years, gdp_growth, marker="o", linestyle="--", color="#1f77b4", label=label_gdp)
plt.plot(years, unemployment_rate, marker="s", linestyle="-", color="#ff7f0e", label=label_unemployment)
plt.plot(years, inflation_rate, marker="^", linestyle=":", color="#2ca02c", label=label_inflation)
plt.plot(years, interest_rate, marker="d", linestyle="-.", color="#d62728", label=label_interest)

# Setting x, y-axis ticks and limits
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)

# Add vertical dotted line to mark significant event year
plt.axvline(x=2016, color="gray", linestyle=":", linewidth=1.2)

# Add legend
plt.legend(loc="upper right", fontsize=12)

# Add labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=14)

# Add grid for better readability
plt.grid(True, which='both', linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_169.pdf", bbox_inches="tight")
