
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D  # Importing Line2D for creating custom legend items

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Importing numpy for numerical operations

# Data
days = np.arange(1, 8)
company_a_prices = [125.5, 127.8, 128.4, 129.6, 130.1, 131.0, 132.3]
company_b_prices = [102.4, 103.1, 104.3, 105.2, 105.9, 107.4, 108.0]

# Axes Limits and Labels
xlabel_value = "Days"

ylabel_value_1 = "Company A Stock Price ($)"
ylabel_value_2 = "Company B Stock Price ($)"
ylim_values_1 = [120, 135]
ylim_values_2 = [100, 110]
yticks_values_1 = range(120, 136, 5)
yticks_values_2 = range(100, 111, 5)

# Labels
label_1 = "Company A"
label_2 = "Company B"
title = "Stock Prices Over a Week"
suptitle = "Financial Data Visualization"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax1 = plt.subplots(figsize=(8, 7))

# Company A plot
(company_a_line,) = ax1.plot(
    days,
    company_a_prices,
    "o-",
    color="#2ca02c",
    label=label_1,
    markersize=10,
    linewidth=3,
    mec="black",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color="#2ca02c")
ax1.tick_params(
    axis="y", labelcolor="#2ca02c", direction="in", rotation=90, labelsize=12
)
ax1.tick_params(
    axis="x",
    direction="in",
    labelsize=12,
)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

# Adding stock prices to the plot for Company A
for i, txt in enumerate(company_a_prices):
    ax1.annotate(
        f"${txt}",
        (days[i], txt),
        textcoords="offset points",
        xytext=(10, 10),
        ha="center",
        fontsize=12,
    )

# Company B plot with a secondary y-axis
ax2 = ax1.twinx()
(company_b_line,) = ax2.plot(
    days,
    company_b_prices,
    "s-",
    color="#d62728",
    label=label_2,
    markersize=10,
    linewidth=3,
    mec="black",
)
ax2.set_ylabel(ylabel_value_2, color="#d62728", fontsize=14)
ax2.tick_params(
    axis="y", labelcolor="#d62728", direction="in", rotation=90, labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# Adding stock prices to the plot for Company B
for i, txt in enumerate(company_b_prices):
    ax2.annotate(
        f"${txt}",
        (days[i], txt),
        textcoords="offset points",
        xytext=(0, -30),
        ha="center",
        fontsize=12,
    )

# Creating custom legend items
company_a_legend = Line2D([0], [0], color="#2ca02c", linewidth=3, label=label_1)
company_b_legend = Line2D([0], [0], color="#d62728", linewidth=3, label=label_2)

# Adding legends
first_legend = ax1.legend(
    handles=[company_a_legend, company_b_legend],
    loc="upper left",
    ncol=2,
    fontsize=14,
    edgecolor="black",
)
ax1.add_artist(first_legend)  # Add the first legend manually

# ===================
# Part 4: Saving Output
# ===================
plt.title(title, fontsize=16)
plt.suptitle(suptitle, fontsize=18)
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_171.pdf", bbox_inches="tight")
