
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# New Data for plotting in E-commerce Sales Analysis domain
advertising_expenditure = np.array(
    [100, 200, 300, 400, 500, 600, 700, 800, 900, 1000]
)
sales_revenue = np.array([150, 280, 350, 460, 590, 660, 780, 860, 920, 1050])

# Labels and Plot Types
x_first_campaign = 300
label_first_campaign = "First Campaign"
x_major_campaign = 700
label_major_campaign = "Major Campaign"
label_sales_trend = "Sales Trend"

# Axes Limits and Labels
yticks_values = np.arange(0, 1100, 100)
ylim_values = [0, 1100]
xlabel_value = "Advertising Expenditure (in $)"
ylabel_value = "Sales Revenue (in $)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Add vertical lines for significant campaigns
ax.axvline(
    x=x_first_campaign,
    color="#e41a1c",
    linestyle="--",
    label=label_first_campaign,
    linewidth=2.5,
)
ax.axvline(
    x=x_major_campaign,
    color="#377eb8",
    linestyle="--",
    label=label_major_campaign,
    linewidth=2.5,
)

# Plot the sales trend line
ax.plot(
    advertising_expenditure,
    sales_revenue,
    label=label_sales_trend,
    color="#4daf4a",
    marker="D",
    markersize=7,
    mec="black",
    linewidth=2.5,
)

# Set yticks
plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)  # Adjust y-axis limit

# Customize the plot
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title("E-commerce Sales Analysis", fontsize=16, pad=20)

# Add grid for major ticks only
ax.grid(True, which="major", linestyle="-", linewidth=0.5, alpha=0.7)

# Add legend
ax.legend(loc="upper left", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Adjust layout to not cut off legend
plt.savefig("line_175.pdf", bbox_inches="tight")
