
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Sample data
time_periods = np.array([f"Q{i+1}" for i in range(10)])
product_a_scores = np.array([65, 68, 70, 73, 75, 77, 78, 80, 79, 81])
product_b_scores = np.array([60, 62, 64, 66, 68, 69, 70, 71, 72, 73])
product_a_std = np.array([2] * 10)
product_b_std = np.array([2.5] * 10)

# Axes Limits and Labels
xlabel_value = "Time Period"
ylabel_value = "Satisfaction Score"
xlim_values = [-0.5, 9.5]
xticks_values = np.arange(10)

# Titles
titles = ["Product A over Time", "Product B over Time", "Comparison"]

# Labels
labels = ["Product A", "Product B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot settings
fig, axs = plt.subplots(1, 3, figsize=(18, 6))
colors = ["#1f77b4", "#ff7f0e"]  # Custom business-like colors
markers = ["o", "^"]  # Circle and triangle markers

for i, ax in enumerate(axs):
    if i < 2:
        scores = product_a_scores if i == 0 else product_b_scores
        stds = product_a_std if i == 0 else product_b_std
        label = labels[i]
        color = colors[i]

        ax.plot(time_periods, scores, label=label, color=color, marker=markers[i], linewidth=2, linestyle="--")
        ax.fill_between(time_periods, scores - stds, scores + stds, color=color, alpha=0.2)
    else:
        ax.plot(time_periods, product_a_scores, label=labels[0], color=colors[0], marker=markers[0], linewidth=2, linestyle="--")
        ax.fill_between(time_periods, product_a_scores - product_a_std, product_a_scores + product_a_std, color=colors[0], alpha=0.2)
        ax.plot(time_periods, product_b_scores, label=labels[1], color=colors[1], marker=markers[1], linewidth=2, linestyle="--")
        ax.fill_between(time_periods, product_b_scores - product_b_std, product_b_scores + product_b_std, color=colors[1], alpha=0.2)

    ax.set_xticks(xticks_values)
    ax.set_xticklabels(time_periods)
    ax.set_xlim(xlim_values)
    ax.set_title(titles[i], fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.grid(True, linestyle='--', alpha=0.7)

# Adjust subplot layout
plt.subplots_adjust(wspace=0.3)

# Set y-axis properties
for ax in axs:
    ax.set_ylabel(ylabel_value, fontsize=12)
    ax.set_ylim([55, 85])
    ax.legend(loc="lower right", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_176.pdf", bbox_inches="tight")
