
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
months = np.array(range(1, 11))
product_a_sales = np.array([10, 15, 13, 20, 24, 18, 22, 25, 27, 30])
product_b_sales = np.array([8, 12, 11, 15, 19, 16, 21, 23, 24, 29])
product_a_std = np.array([1.5, 2.0, 1.8, 2.5, 2.8, 2.2, 2.4, 3.0, 3.5, 4.0])
product_b_std = np.array([1.2, 1.5, 1.4, 1.8, 2.1, 2.0, 2.6, 2.8, 3.0, 3.5])

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [0.5, 10.5]
xticks_values = np.arange(1, 11, 1)

ylabel_value = "Sales (in thousands)"
yticks_values_1 = np.arange(8, 32, 4)
ylim_values_1 = [6, 32]
yticks_values_2 = np.arange(8, 32, 4)
ylim_values_2 = 6, 32
yticks_values_3 = np.arange(8, 32, 4)
ylim_values_3 = [6, 32]

# Labels
labels = ["Product A", "Product B"]

# Titles
titles = ["Sales Trend for Product A", "Sales Trend for Product B", "Combined Sales Trend"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot settings
fig, axs = plt.subplots(1, 3, figsize=(15, 5))
colors = ["#1f77b4", "#2ca02c"]  # Custom colors
markers = ["o", "^"]  # Different markers

for i, ax in enumerate(axs):
    if i == 0:  # Product A
        ax.plot(
            months, product_a_sales, label=labels[0], color=colors[0], marker=markers[0]
        )
        ax.fill_between(
            months,
            product_a_sales - product_a_std,
            product_a_sales + product_a_std,
            color=colors[0],
            alpha=0.2,
        )
    elif i == 1:  # Product B
        ax.plot(
            months, product_b_sales, label=labels[1], color=colors[1], marker=markers[1]
        )
        ax.fill_between(
            months,
            product_b_sales - product_b_std,
            product_b_sales + product_b_std,
            color=colors[1],
            alpha=0.2,
        )
    else:  # Combined
        ax.plot(
            months, product_a_sales, label=labels[0], color=colors[0], marker=markers[0]
        )
        ax.fill_between(
            months,
            product_a_sales - product_a_std,
            product_a_sales + product_a_std,
            color=colors[0],
            alpha=0.2,
        )
        ax.plot(
            months, product_b_sales, label=labels[1], color=colors[1], marker=markers[1]
        )
        ax.fill_between(
            months,
            product_b_sales - product_b_std,
            product_b_sales + product_b_std,
            color=colors[1],
            alpha=0.2,
        )
    ax.set_xticks(xticks_values)
    ax.set_xlim(xlim_values)
    ax.set_title(titles[i])
    ax.set_xlabel(xlabel_value)
    ax.grid(True)

# Adjust subplot layout
plt.subplots_adjust(wspace=0.3)

axs[0].set_yticks(yticks_values_1)
axs[0].set_ylim(ylim_values_1)
axs[1].set_yticks(yticks_values_2)
axs[1].set_ylim(ylim_values_2)
axs[2].set_yticks(yticks_values_3)
axs[2].set_ylim(ylim_values_3)

# Move legend inside the plot area
axs[0].legend(loc="upper left")
axs[1].legend(loc="upper left")
axs[2].legend(loc="upper left")

# Adjust y-axis label to match reference picture
axs[0].set_ylabel(ylabel_value)
axs[1].set_ylabel(ylabel_value)
axs[2].set_ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_177.pdf", bbox_inches="tight")

