
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for energy efficiency
usage_levels = np.arange(0.1, 1.1, 0.1)
tech_a_efficiency = np.array([0.85, 0.87, 0.9, 0.92, 0.93, 0.94, 0.95, 0.96, 0.97, 0.98])
tech_b_efficiency = np.array([0.8, 0.82, 0.83, 0.85, 0.87, 0.88, 0.89, 0.91, 0.92, 0.94])
tech_a_std = np.array([0.03] * 10)
tech_b_std = np.array([0.04] * 10)

# Axes Limits and Labels
xlabel_value = "Usage Level"
xlim_values = [0.05, 1.05]
xticks_values = np.arange(0.1, 1.1, 0.1)

ylabel_value = "Energy Efficiency"
yticks_values_1 = np.arange(0.75, 1.0, 0.05)
ylim_values_1 = [0.75, 1.0]
yticks_values_2 = np.arange(0.75, 1.0, 0.05)
ylim_values_2 = [0.75, 1.0]
yticks_values_3 = np.arange(0.75, 1.0, 0.05)
ylim_values_3 = [0.75, 1.0]

# Labels
labels = ["Tech A", "Tech B"]

# Titles
titles = ["Efficiency at 50% Load", "Efficiency at 70% Load", "Efficiency at 90% Load"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot settings
fig, axs = plt.subplots(1, 3, figsize=(15, 5))
colors = ["#1f77b4", "#2ca02c"]  # Blue and Green
markers = ["o", "D"]  # Circle and Diamond markers

for i, ax in enumerate(axs):
    ax.plot(
        usage_levels, tech_a_efficiency, label=labels[0], color=colors[0], marker=markers[0]
    )
    ax.fill_between(
        usage_levels,
        tech_a_efficiency - tech_a_std,
        tech_a_efficiency + tech_a_std,
        color=colors[0],
        alpha=0.2,
    )
    ax.plot(
        usage_levels, tech_b_efficiency, label=labels[1], color=colors[1], marker=markers[1]
    )
    ax.fill_between(
        usage_levels,
        tech_b_efficiency - tech_b_std,
        tech_b_efficiency + tech_b_std,
        color=colors[1],
        alpha=0.2,
    )
    ax.set_xticks(xticks_values)
    ax.set_xlim(xlim_values)
    ax.set_title(titles[i])
    ax.set_xlabel(xlabel_value)
    ax.grid(True)

# Adjust subplot layout
plt.subplots_adjust(wspace=0.3)

axs[0].set_yticks(yticks_values_1)
axs[0].set_ylim(ylim_values_1)
axs[1].set_yticks(yticks_values_2)
axs[1].set_ylim(ylim_values_2)
axs[2].set_yticks(yticks_values_3)
axs[2].set_ylim(ylim_values_3)

# Move legend inside the plot area
axs[0].legend(loc="upper left")
axs[1].legend(loc="lower right")
axs[2].legend(loc="lower left")

# Adjust y-axis label to match reference picture
axs[0].set_ylabel(ylabel_value)
axs[1].set_ylabel(ylabel_value)
axs[2].set_ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_178.pdf", bbox_inches="tight")
