
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data: Monthly tourist arrivals
months = np.arange(1, 13, 1)
tourist_arrivals_mean = np.array([
    2500, 2700, 3000, 3200, 3500, 3700, 4000, 4100, 4300, 4500, 4200, 3900
])
tourist_arrivals_std = np.array([
    200, 220, 180, 160, 190, 210, 230, 220, 210, 200, 180, 170
])

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0.5, 12.5]
xticks_values = np.arange(1, 13, 1)

ylabel_value = "Number of Tourists"
ylim_values = [2000, 4800]

# Chart title and legend labels
chart_title = "Average Monthly Tourist Arrivals"
legend_label_mean = "Mean Tourist Arrivals"
legend_label_std = "Standard Deviation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the mean tourist arrivals with the standard deviation as a shaded area
plt.figure(figsize=(10, 6))
plt.plot(months, tourist_arrivals_mean, color="#2ca02c", linestyle='--', linewidth=2, label=legend_label_mean)
plt.fill_between(
    months,
    tourist_arrivals_mean - tourist_arrivals_std,
    tourist_arrivals_mean + tourist_arrivals_std,
    color="#98df8a",
    alpha=0.3,
    label=legend_label_std
)

# Set x-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=12)
plt.yticks(fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Labeling the axes and chart title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(chart_title, fontsize=18)

# Adding legend
plt.legend(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_181.pdf", bbox_inches="tight")
