
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
epochs = ["3", "10", "30", "100"]  # Treat epochs as strings to make them categorical
baseline_model = [0.75, 0.78, 0.78, 0.78]
model_a = [0.65, 0.70, 0.72, 0.74]
model_b = [0.55, 0.63, 0.60, 0.68]
model_c = [0.50, 0.58, 0.62, 0.70]
model_d = [0.45, 0.55, 0.60, 0.65]
model_e = [0.35, 0.50, 0.58, 0.63]

# Axes Limits and Labels
xlabel_value = "# Epochs"
ylabel_value = "Classification Accuracy"
ylim_values = [0.3, 0.85]
yticks_values = np.arange(0.35, 0.85, 0.1)

# Labels
label_baseline = "Baseline Model"
label_a = "Model A"
label_b = "Model B"
label_c = "Model C"
label_d = "Model D"
label_e = "Model E"

# Plot Title
title_value = "Legal Text Classification Model Performance"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 5))
plt.axhline(y=0.78, color="grey", linestyle="--", linewidth=2, label=label_baseline)
plt.plot(epochs, model_a, color="#1f77b4", marker="o", linestyle="-", linewidth=2, label=label_a)
plt.plot(epochs, model_b, color="#ff7f0e", marker="s", linestyle="-", linewidth=2, label=label_b)
plt.plot(epochs, model_c, color="#2ca02c", marker="^", linestyle="-", linewidth=2, label=label_c)
plt.plot(epochs, model_d, color="#d62728", marker="v", linestyle="-", linewidth=2, label=label_d)
plt.plot(epochs, model_e, color="#9467bd", marker="d", linestyle="-", linewidth=2, label=label_e)

plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)

# Set x-axis labels equidistantly
ax = plt.gca()
ax.set_xticks(np.arange(len(epochs)))
ax.set_xticklabels(epochs, fontsize=12)

plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)

plt.legend(
    loc="lower right", ncol=2, fontsize=12, columnspacing=5
)  # Adjusted legend settings

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_182.pdf", bbox_inches="tight")
