
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for each subplot
years = [2015, 2016, 2017, 2018, 2019]
gdp_growth = [2.5, 2.9, 2.3, 2.2, 2.0]  # GDP growth rate
unemployment_rate = [5.3, 4.9, 4.4, 3.9, 3.7]  # Unemployment rate
inflation_rate = [0.1, 1.3, 2.1, 2.4, 2.3]  # Inflation rate
stock_index = [2050, 2150, 2350, 2450, 2550]  # Stock market index

# Axes Limits and Labels
xlim_values = [2014, 2020]
xticks_values = years

ylabel_value = "Value"
ylim_values_gdp = [1.5, 3.5]
yticks_values_gdp = np.arange(1.5, 3.6, 0.5)
ylim_values_unemployment = [3, 6]
yticks_values_unemployment = np.arange(3, 6.1, 0.5)
ylim_values_inflation = [0, 3]
yticks_values_inflation = np.arange(0, 3.1, 0.5)
ylim_values_stock = [2000, 2600]
yticks_values_stock = np.arange(2000, 2601, 100)

# Labels
label_gdp = "GDP Growth Rate"
label_unemployment = "Unemployment Rate"
label_inflation = "Inflation Rate"
label_stock = "Stock Index"

# Titles
title_gdp = "GDP Growth Over Years"
title_unemployment = "Unemployment Rate Over Years"
title_inflation = "Inflation Rate Over Years"
title_stock = "Stock Market Index Over Years"

# Datasets
datasets = ["GDP Growth", "Unemployment Rate", "Inflation Rate", "Stock Market Index"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 4, figsize=(20, 5))

# Plot data on each subplot
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]  # New Color Scheme

axs[0].plot(years, gdp_growth, "o--", label=label_gdp, color=colors[0], markersize=10, linewidth=2)
axs[0].set_xticks(xticks_values)
axs[0].set_title(datasets[0], fontsize=14)
axs[0].set_ylabel(ylabel_value, fontsize=14)
axs[0].set_yticks(yticks_values_gdp)
axs[0].set_ylim(ylim_values_gdp)

axs[1].plot(years, unemployment_rate, "^--", label=label_unemployment, color=colors[1], markersize=10, linewidth=2)
axs[1].set_xticks(xticks_values)
axs[1].set_title(datasets[1], fontsize=14)
axs[1].set_ylabel(ylabel_value, fontsize=14)
axs[1].set_yticks(yticks_values_unemployment)
axs[1].set_ylim(ylim_values_unemployment)

axs[2].plot(years, inflation_rate, "s--", label=label_inflation, color=colors[2], markersize=10, linewidth=2)
axs[2].set_xticks(xticks_values)
axs[2].set_title(datasets[2], fontsize=14)
axs[2].set_ylabel(ylabel_value, fontsize=14)
axs[2].set_yticks(yticks_values_inflation)
axs[2].set_ylim(ylim_values_inflation)

axs[3].plot(years, stock_index, "*--", label=label_stock, color=colors[3], markersize=10, linewidth=2)
axs[3].set_xticks(xticks_values)
axs[3].set_title(datasets[3], fontsize=14)
axs[3].set_ylabel(ylabel_value, fontsize=14)
axs[3].set_yticks(yticks_values_stock)
axs[3].set_ylim(ylim_values_stock)

plt.legend(loc="center", bbox_to_anchor=(-1.6, -0.2), ncol=4, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_185.pdf", bbox_inches="tight")
