
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for each subplot (Example data generated for tourism domain)
x = ["Jan", "Feb", "Mar", "Apr", "May", "Jun"]

# Monthly tourist arrivals for four different regions (thousands)
y1_0 = [50, 65, 75, 80, 90, 120]  # Region 1
y2_0 = [40, 45, 60, 70, 85, 110]  # Region 2
y3_0 = [20, 30, 45, 55, 60, 80]   # Region 3
y4_0 = [10, 15, 25, 30, 40, 50]   # Region 4

# International vs Domestic tourists comparison (thousands)
y1_1 = [30, 40, 50, 55, 60, 80]  # International
y2_1 = [10, 15, 20, 25, 30, 45]  # Domestic

# Seasonal tourist trends (thousands)
y1_2 = [40, 50, 60, 70, 80, 100]  # Spring
y2_2 = [20, 30, 40, 50, 60, 90]   # Summer
y3_2 = [10, 20, 30, 40, 50, 70]   # Autumn
y4_2 = [5,  10, 20, 25, 35, 50]   # Winter

# Average spending per tourist (USD)
y1_3 = [700, 750, 800, 820, 850, 900]  # Region 1
y2_3 = [650, 700, 750, 770, 800, 850]  # Region 2
y3_3 = [600, 650, 700, 720, 750, 800]  # Region 3
y4_3 = [550, 600, 650, 670, 700, 750]  # Region 4

# Axes Limits and Labels
xlim_values = [0, 6]
xticks_values = x

ylabel_value = "Tourist Arrivals (Thousands)"
ylim_values_1 = [0, 130]
yticks_values_1 = np.arange(0, 131, 20)
ylabel_2 = "Tourist Arrivals (Thousands)"
ylim_values_2 = [0, 90]
yticks_values_2 = np.arange(0, 91, 15)
ylabel_3 = "Tourist Arrivals (Thousands)"
ylim_values_3 = [0, 110]
yticks_values_3 = np.arange(0, 111, 20)
ylabel_4 = "Average Spending (USD)"
ylim_values_4 = [500, 950]
yticks_values_4 = np.arange(500, 951, 100)

# Labels
label_1 = "Region 1"
label_2 = "Region 2"
label_3 = "Region 3"
label_4 = "Region 4"

label_intl = "International"
label_domestic = "Domestic"
label_spring = "Spring"
label_summer = "Summer"
label_autumn = "Autumn"
label_winter = "Winter"

# Titles for each subplot
title_1 = "Monthly Tourist Arrivals by Region"
title_2 = "International vs Domestic Tourists"
title_3 = "Seasonal Tourist Trends"
title_4 = "Average Spending per Tourist"

# Plot data on each subplot
datasets = ["Region 1", "Region 2", "Region 3", "Region 4"]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 4, figsize=(20, 5))
# Color scheme (customized for tourism theme)
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot data on each subplot
axs[0].plot(x, y1_0, "o--", label=label_1, color=colors[0], markersize=10)
axs[0].plot(x, y2_0, "^--", label=label_2, color=colors[1], markersize=10)
axs[0].plot(x, y3_0, "s--", label=label_3, color=colors[2], markersize=10)
axs[0].plot(x, y4_0, "*--", label=label_4, color=colors[3], markersize=10)
axs[0].set_xticks(xticks_values)
axs[0].set_title(title_1, fontsize=14)
axs[0].set_ylabel(ylabel_value, fontsize=14)
axs[0].set_yticks(yticks_values_1)
axs[0].set_ylim(ylim_values_1)

axs[1].plot(x, y1_1, "o--", label=label_intl, color="#1f77b4", markersize=10)
axs[1].plot(x, y2_1, "^--", label=label_domestic, color="#ff7f0e", markersize=10)
axs[1].set_xticks(xticks_values)
axs[1].set_title(title_2, fontsize=14)
axs[1].set_ylabel(ylabel_2, fontsize=14)
axs[1].set_yticks(yticks_values_2)
axs[1].set_ylim(ylim_values_2)

axs[2].plot(x, y1_2, "o--", label=label_spring, color=colors[0], markersize=10)
axs[2].plot(x, y2_2, "^--", label=label_summer, color=colors[1], markersize=10)
axs[2].plot(x, y3_2, "s--", label=label_autumn, color=colors[2], markersize=10)
axs[2].plot(x, y4_2, "*--", label=label_winter, color=colors[3], markersize=10)
axs[2].set_xticks(xticks_values)
axs[2].set_title(title_3, fontsize=14)
axs[2].set_ylabel(ylabel_3, fontsize=14)
axs[2].set_yticks(yticks_values_3)
axs[2].set_ylim(ylim_values_3)

axs[3].plot(x, y1_3, "o--", label=label_1, color=colors[0], markersize=10)
axs[3].plot(x, y2_3, "^--", label=label_2, color=colors[1], markersize=10)
axs[3].plot(x, y3_3, "s--", label=label_3, color=colors[2], markersize=10)
axs[3].plot(x, y4_3, "*--", label=label_4, color=colors[3], markersize=10)
axs[3].set_xticks(xticks_values)
axs[3].set_title(title_4, fontsize=14)
axs[3].set_ylabel(ylabel_4, fontsize=14)
axs[3].set_yticks(yticks_values_4)
axs[3].set_ylim(ylim_values_4)

plt.legend(loc="center", bbox_to_anchor=(-1.6, -0.2), ncol=4, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_187.pdf", bbox_inches="tight")
