
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
months = np.linspace(1, 12, 12)
temp_spring = np.random.normal(loc=15, scale=2, size=12).clip(-5, 30)
temp_summer = np.random.normal(loc=25, scale=4, size=12).clip(-5, 35)
temp_fall = np.random.normal(loc=12, scale=3, size=12).clip(-5, 30)
temp_winter = np.random.normal(loc=2, scale=5, size=12).clip(-10, 15)

# Labels and Plot Types
label_temp_spring = "Spring"
label_temp_summer = "Summer"
label_temp_fall = "Fall"
label_temp_winter = "Winter"

xticks_labels = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]

# Axes Limits and Labels
yticks_values = np.arange(-10, 40, 5)
ylim_values = [-15, 40]
xlabel_value = "Month"
ylabel_value = "Temperature (°C)"
title_value = "Average Monthly Temperature for Seasons"
legend_labels = ["Spring", "Summer", "Fall", "Winter"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))  # Increased figure size for clarity
plt.plot(months, temp_spring, "-o", label=label_temp_spring, color="#66c2a5")
plt.fill_between(months, temp_spring - 2, temp_spring + 2, color="#66c2a5", alpha=0.2)
plt.plot(months, temp_summer, "--^", label=label_temp_summer, color="#fc8d62")
plt.fill_between(months, temp_summer - 4, temp_summer + 4, color="#fc8d62", alpha=0.2)
plt.plot(months, temp_fall, "-.x", label=label_temp_fall, color="#8da0cb")
plt.fill_between(months, temp_fall - 3, temp_fall + 3, color="#8da0cb", alpha=0.2)
plt.plot(months, temp_winter, ":s", label=label_temp_winter, color="#e78ac3")
plt.fill_between(months, temp_winter - 5, temp_winter + 5, color="#e78ac3", alpha=0.2)

# Customizing axes and labels (third-level elements)
plt.yticks(yticks_values, fontsize=12)
plt.xticks(months, xticks_labels, fontsize=12)
plt.ylim(ylim_values)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)
plt.grid(True, linestyle='--', linewidth=0.5)

# Relocating the legend to ensure no overlap with data lines
plt.legend(loc="upper left", frameon=True, shadow=True, fontsize=12, labels=legend_labels)

# Customizing the background (third-level element)
plt.gca().set_facecolor("#f4f4f5")
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_188.pdf", bbox_inches="tight")
