
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data: Yearly data from 2000 to 2020
years = np.array([2000, 2005, 2010, 2015, 2020])
religion1_affiliation = np.array([50, 45, 40, 35, 30])
religion2_affiliation = np.array([20, 25, 30, 35, 40])
religion3_affiliation = np.array([30, 30, 30, 30, 30])

# Polynomial trends for illustration
religion2_trend = np.poly1d(np.polyfit(years, religion2_affiliation, 2))(years)

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value_1 = "Percentage Affiliation"
ylabel_value_2 = "Trend Value"
yticks_values_1 = np.arange(0, 51, 10)
yticks_values_2 = np.arange(min(religion2_trend)-5, max(religion2_trend)+5, 5)

# Labels
label_1 = "Religion 1"
label_2 = "Religion 2"
label_3 = "Religion 3"
label_4 = "Trend (Religion 2)"
suptitle = "Religion Affiliation and Trend Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# First subplot
ax1.plot(years, religion1_affiliation, "D--", color="#8a2be2", linewidth=2, label=label_1)
ax1.plot(years, religion2_affiliation, "o-", color="#3cb371", linewidth=2, label=label_2)
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1)
ax1.set_xticks(years)
ax1.set_yticks(yticks_values_1)
ax1.legend(loc="best")
ax1.grid(True)

# Second subplot
ax2.plot(years, religion3_affiliation, "s:", color="#4682b4", linewidth=2, label=label_3)
ax2.plot(years, religion2_trend, "*-r", linewidth=2, label=label_4)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value_2)
ax2.set_xticks(years)
ax2.set_yticks(yticks_values_2)
ax2.legend(loc="best")
ax2.grid(True)

# Annotations and styling
for ax in (ax1, ax2):
    ax.spines["left"].set_position(("outward", 10))
    ax.spines["bottom"].set_position(("outward", 10))
    ax.spines["right"].set_color("none")
    ax.spines["top"].set_color("none")
for x, y in zip(years, religion1_affiliation):
    ax1.annotate(
        f"{y}%", xy=(x, y), textcoords="offset points", xytext=(0, 10), ha="center"
    )

# Overall title and layout
fig.suptitle(suptitle, fontsize=16)
plt.tight_layout()
plt.subplots_adjust(top=0.9)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_194.pdf", bbox_inches="tight")
