
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Data: Box office revenue for five movie releases
release_steps = np.array([1, 2, 3, 4, 5])
revenue_series_1 = np.array([100, 150, 120, 130, 170])  # Franchise 1
revenue_series_2 = np.array([90, 110, 140, 160, 180])   # Franchise 2
revenue_series_3 = np.array([130, 160, 150, 170, 200])  # Franchise 3
poly_trend = np.poly1d(np.polyfit(release_steps, revenue_series_2, 3))(release_steps)

# Axes Limits and Labels
xlabel_value = "Movie Release Number"
ylabel_value_1 = "Box Office Revenue (in millions)"
ylabel_value_2 = "Polynomial Trend (Franchise 2)"
yticks_values_1 = np.arange(0, 201, 50)
yticks_values_2 = np.arange(min(poly_trend), max(poly_trend) + 5, 20)

# Labels
label_1 = "Franchise 1"
label_2 = "Franchise 2"
label_3 = "Polynomial Trend (from Franchise 2)"
label_4 = "Franchise 3"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# First subplot
ax1.plot(release_steps, revenue_series_1, 'o-', color='#FF5733', label=label_1)  # Orange color
ax1.plot(release_steps, revenue_series_2, 's-', color='#33FF57', label=label_2)  # Green color
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1)
ax1.set_xticks(release_steps)
ax1.set_yticks(yticks_values_1)
ax1.legend(loc="upper left")
ax1.grid(True)

# Second subplot
ax2.plot(release_steps, revenue_series_3, '^--', color='#3357FF', label=label_4)  # Blue color
ax2.plot(release_steps, poly_trend, '*-m', label=label_3)  # Magenta color
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value_2)
ax2.set_xticks(release_steps)
ax2.set_yticks(yticks_values_2)
ax2.legend(loc="upper right")
ax2.grid(True)

# Annotations and styling
for ax in (ax1, ax2):
    ax.spines["left"].set_position(("outward", 10))
    ax.spines["bottom"].set_position(("outward", 10))
    ax.spines["right"].set_color("none")
    ax.spines["top"].set_color("none")

for x, y in zip(release_steps, revenue_series_1):
    ax1.annotate(
        f"${y}", xy=(x, y), textcoords="offset points", xytext=(0, 10), ha="center"
    )

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_195.pdf", bbox_inches="tight")
