
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Simulated Finance Data
years = np.array(["2018", "2019", "2020", "2021", "2022", "2023"])
company_a = np.array([120, 135, 150, 160, 155, 165])
company_a_err = np.array([5, 6, 4, 5, 7, 6])
company_b = np.array([100, 118, 130, 125, 140, 145])
company_b_err = np.array([4, 5, 5, 6, 7, 5])
company_c = np.array([90, 100, 120, 110, 130, 140])
company_c_err = np.array([5, 6, 5, 7, 8, 6])
company_d = np.array([110, 115, 125, 130, 135, 150])
company_d_err = np.array([4, 5, 6, 5, 6, 7])

# Axes Limits and Labels
ylabel_value = "Stock Prices ($)"
ylim_values = [80, 180]
yticks_values = np.arange(80, 181, 20)

# Labels
label_a = "Company A"
label_b = "Company B"
label_c = "Company C"
label_d = "Company D"

# Titles
title_1 = "Stock Prices Over Years (Group 1)"
title_2 = "Stock Prices Over Years (Group 2)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot layout of 1x2
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5), sharey=True)

# First subplot for Group 1
ax1.errorbar(
    years,
    company_a,
    yerr=company_a_err,
    fmt="o-",
    label=label_a,
    color="#1f77b4",
    capsize=5,
    linewidth=2
)
ax1.errorbar(
    years,
    company_b,
    yerr=company_b_err,
    fmt="^-",
    label=label_b,
    color="#ff7f0e",
    capsize=5,
    linewidth=2
)
ax1.set_title(title_1)
ax1.set_xticks(years)
ax1.set_xticklabels(years, rotation=45, ha="right", fontsize=12)
ax1.set_yticks(yticks_values)
ax1.set_ylim(ylim_values)
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax1.set_ylabel(ylabel_value, fontsize=16)
ax1.legend(loc="upper left", fontsize=12)

# Second subplot for Group 2
ax2.errorbar(
    years,
    company_c,
    yerr=company_c_err,
    fmt="s--",
    label=label_c,
    color="#2ca02c",
    capsize=5,
    linewidth=2
)
ax2.errorbar(
    years,
    company_d,
    yerr=company_d_err,
    fmt="o-.",
    label=label_d,
    color="#d62728",
    capsize=5,
    linewidth=2
)
ax2.set_title(title_2)
ax2.set_xticks(years)
ax2.set_xticklabels(years, rotation=45, ha="right", fontsize=12)
ax2.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax2.legend(loc="upper left", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout
plt.tight_layout()
plt.savefig("line_198.pdf", bbox_inches="tight")
