
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulated data for energy consumption (in terawatt-hours)
countries_x = np.array(
    ["USA", "China", "India", "Germany", "UK", "France", "Brazil", "Japan"]
)
energy_2022 = np.array([2000, 3000, 1500, 500, 450, 400, 100, 800])
error_2022 = np.array([100, 150, 50, 20, 25, 30, 10, 40])
energy_2023 = np.array([2100, 3100, 1600, 520, 460, 410, 110, 820])
error_2023 = np.array([110, 160, 60, 25, 30, 35, 15, 45])

ylabel_value = "Energy Consumption (TWh)"
xlabel_value = "Countries"
ylim_values = [0, 3500]
yticks_values = np.arange(0, 3501, 500)

# Labels
label_1 = "Energy Consumption 2022"
label_2 = "Energy Consumption 2023"

# Titles
title_1 = "Energy Consumption in 2022"
title_2 = "Energy Consumption in 2023"
suptitle = "Energy Consumption in Different Countries Over the Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot layout of 1x2
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 6), sharey=True)

# First subplot for 2022
ax1.errorbar(
    countries_x,
    energy_2022,
    yerr=error_2022,
    fmt="o-",
    label=label_1,
    color="#1f77b4",  # Blue color
    capsize=5,
    linewidth=2,
    markersize=8,
)
ax1.set_title(title_1)
ax1.set_xticks(countries_x)
ax1.set_xticklabels(countries_x, rotation=45, ha="right", fontsize=12)
ax1.set_yticks(yticks_values)
ax1.set_ylim(ylim_values)
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax1.set_ylabel(ylabel_value, fontsize=16)
ax1.legend(loc="upper left", fontsize=12)

# Second subplot for 2023
ax2.errorbar(
    countries_x,
    energy_2023,
    yerr=error_2023,
    fmt="s-",
    label=label_2,
    color="#ff7f0e",  # Orange color
    capsize=5,
    linewidth=2,
    markersize=8,
)
ax2.set_title(title_2)
ax2.set_xticks(countries_x)
ax2.set_xticklabels(countries_x, rotation=45, ha="right", fontsize=12)
ax2.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax2.legend(loc="upper left", fontsize=12)

# Set supertitle for the entire figure
plt.suptitle(suptitle, fontsize=18)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_199.pdf", bbox_inches="tight")
