
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting, using random noise to add variability
time = np.array([1, 2, 3, 4, 5, 6])
signal_strength = np.power(10, -np.linspace(1, 3, len(time)))
noise_level = np.power(10, -np.random.uniform(2, 4, len(time)))
bandwidth_efficiency = np.power(10, -np.linspace(0.5, 2.5, len(time)))
error_rate = np.power(10, -np.random.uniform(1.5, 3.5, len(time)))

# Axes Limits and Labels
xlabel_value = "Time (s)"
ylabel_value = "Metric Value"

# Labels
label_SignalStrength = "Signal Strength"
label_NoiseLevel = "Noise Level"
label_BandwidthEfficiency = "Bandwidth Efficiency"
label_ErrorRate = "Error Rate"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the data using different styles and colors
plt.loglog(
    time,
    signal_strength,
    "o-",
    color="teal",
    label=label_SignalStrength,
    markerfacecolor="teal",
    markersize=8,
    linewidth=2,
)
plt.loglog(
    time,
    noise_level,
    "x-",
    color="magenta",
    label=label_NoiseLevel,
    markersize=8,
    linewidth=2,
)
plt.loglog(
    time,
    bandwidth_efficiency,
    "s--",
    color="orange",
    label=label_BandwidthEfficiency,
    markersize=8,
    linewidth=2,
)
plt.loglog(
    time,
    error_rate,
    "^-",
    color="navy",
    label=label_ErrorRate,
    markersize=8,
    linewidth=2,
)

# Customize the x and y axes limits and labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.xticks(time, labels=[str(t) + "s" for t in time])  # Ensuring x-ticks match the time values with unit
plt.xlim(
    left=time[0] * 0.9, right=time[-1] * 1.1
)  # Set x-axis limits to prevent cutting off data points
plt.ylim(
    bottom=1e-4, top=1e-0
)  # Adjust y-axis limits based on new data range

# Adjust the legend position
plt.legend(bbox_to_anchor=(1, 0.5), fontsize=12, frameon=True)

# Add grid lines for better readability
plt.grid(True, which="both", ls="--", color="grey", linewidth=1, alpha=0.5)


# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the plot
plt.tight_layout()
plt.savefig("line_200.pdf", bbox_inches="tight")

