
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting, using random noise to add variability
N = np.array([10, 20, 30, 40, 50, 60])
high_achievers = np.random.uniform(80, 100, len(N))
average_students = np.random.uniform(60, 79, len(N))
below_average = np.random.uniform(40, 59, len(N))
at_risk = np.random.uniform(20, 39, len(N))

# Axes Limits and Labels
xlabel_value = "Number of Students"
ylabel_value = "Test Scores (%)"

# Labels
label_HighAchievers = "High Achievers"
label_AverageStudents = "Average Students"
label_BelowAverage = "Below Average"
label_AtRisk = "At Risk"
title="Student Performance Over Different Student Counts"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the data using different styles and colors
plt.plot(
    N,
    high_achievers,
    "o-",
    color="#2a9d8f",
    label=label_HighAchievers,
    markerfacecolor="#2a9d8f",
    markersize=8,
    linewidth=2,
)
plt.plot(
    N,
    average_students,
    "s--",
    color="#f4a261",
    label=label_AverageStudents,
    markerfacecolor="#f4a261",
    markersize=8,
    linewidth=2,
)
plt.plot(
    N,
    below_average,
    "^-",
    color="#e76f51",
    label=label_BelowAverage,
    markerfacecolor="#e76f51",
    markersize=8,
    linewidth=2,
)
plt.plot(
    N,
    at_risk,
    "x:",
    color="#264653",
    label=label_AtRisk,
    markerfacecolor="#264653",
    markersize=8,
    linewidth=2,
)

# Customize the x and y axes limits and labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.xticks(N, labels=[str(n) for n in N])  # Ensure x-ticks match the N values
plt.xlim(left=N[0] * 0.9, right=N[-1] * 1.1)  # Set x-axis limits
plt.ylim(bottom=0, top=110)  # Extend y-axis to provide some space above data

# Adjust the legend position
plt.legend(bbox_to_anchor=(1, 0.5), fontsize=12, frameon=True)

# Add grid lines for better readability
plt.grid(True, which="both", ls="--", color="grey", linewidth=1, alpha=0.5)

# Add a title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the plot
plt.tight_layout()
plt.savefig("line_201.pdf", bbox_inches="tight")

