
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting - Weather conditions over 6 months
months = np.array([1, 2, 3, 4, 5, 6])
temperature = np.random.uniform(15, 35, len(months))  # Temperature in Celsius
humidity = np.random.uniform(50, 90, len(months))      # Humidity in %
wind_speed = np.random.uniform(0, 15, len(months))     # Wind speed in km/h
precipitation = np.random.uniform(0, 200, len(months)) # Precipitation in mm

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Values"
title_value = "Monthly Weather Conditions"

# Labels
label_Temperature = "Temperature (°C)"
label_Humidity = "Humidity (%)"
label_WindSpeed = "Wind Speed (km/h)"
label_Precipitation = "Precipitation (mm)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the data using different styles and colors
plt.plot(
    months,
    temperature,
    "o-",
    color="#ffa07a",
    label=label_Temperature,
    markerfacecolor="#ffa07a",
    markersize=8,
    linewidth=2,
)
plt.plot(
    months,
    humidity,
    "s--",
    color="#3cb371",
    label=label_Humidity,
    markersize=8,
    linewidth=2,
)
plt.plot(
    months,
    wind_speed,
    "^-",
    color="#ff7f50",
    label=label_WindSpeed,
    markersize=8,
    linewidth=2,
)
plt.plot(
    months,
    precipitation,
    "d-.",
    color="#4682b4",
    label=label_Precipitation,
    markersize=8,
    linewidth=2,
)

# Customize the x and y axes limits and labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)
plt.xticks(months, labels=[str(m) for m in months])
plt.xlim(left=0.9, right=6.1)
plt.ylim(bottom=0, top=max(np.max(temperature), np.max(humidity), np.max(wind_speed), np.max(precipitation)) * 1.1)

# Adjust the legend position
plt.legend(bbox_to_anchor=(1, 0.5), fontsize=12, frameon=True)

# Add grid lines for better readability
plt.grid(True, which="both", ls="--", color="grey", linewidth=1, alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the plot
plt.tight_layout()
plt.savefig("line_202.pdf", bbox_inches="tight")
