
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data representing religious activities over a day
times = np.linspace(0, 24, 25)
attendance = np.sin(times / 3) + np.random.normal(0, 0.1, len(times))
prayer = np.cos(times / 2) * 0.8 + np.random.normal(0, 0.1, len(times))

# Extracted variables
line_label1 = "Service Attendance"
line_label2 = "Prayer Activity"
xlim_values = (0, 24)
ylim_values = (-1.5, 1.5)
xlabel_value = "Time (Hours)"
ylabel_value = "Activity Level"
yticks_values = [-1.5, -1.0, -0.5, 0, 0.5, 1, 1.5]
title1 = "Daily Service Attendance"
title2 = "Daily Prayer Activity"
legend_location = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, axs = plt.subplots(2, 1, figsize=(8, 12))  # Adjusted figure size for better clarity

# Define new colors and markers for a fresh look
colors = ["deepskyblue", "forestgreen"]
linestyles = ["-", "--"]
labels = [line_label1, line_label2]

# First subplot for Service Attendance
axs[0].plot(times, attendance, color=colors[0], linestyle=linestyles[0], label=labels[0])
axs[0].set_title(title1, fontsize=14)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value, fontsize=12)
axs[0].set_xlim(xlim_values)
axs[0].set_ylim(ylim_values)
axs[0].set_yticks(yticks_values)
axs[0].legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon, fontsize=10)
axs[0].tick_params(axis="both", which="both", length=0)

# Second subplot for Prayer Activity
axs[1].plot(times, prayer, color=colors[1], linestyle=linestyles[1], label=labels[1])
axs[1].set_title(title2, fontsize=14)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_value, fontsize=12)
axs[1].set_xlim(xlim_values)
axs[1].set_ylim(ylim_values)
axs[1].set_yticks(yticks_values)
axs[1].legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon, fontsize=10)
axs[1].tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout and visuals
plt.tight_layout()
plt.savefig("line_206.pdf", bbox_inches="tight")
