
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data for plotting, based on economic indicators
months = np.arange(0, 24, 1)  # 0 to 23 representing two years (24 months)
gdp_growth = np.sin(months * 0.2) + np.random.normal(0, 0.1, len(months))  # Simulated GDP growth
unemployment_rate = np.cos(months * 0.2) + np.random.normal(0, 0.1, len(months))  # Simulated Unemployment rate

# Extracted variables for chart text labels and styles
line_label1 = "GDP Growth"
line_label2 = "Unemployment Rate"
xlim_values = (0, 23)
ylim_values = (-1.5, 1.5)
xlabel_value = "Time (Months)"
ylabel_value = "Percentage"
yticks_values = [-1.5, -1.0, -0.5, 0, 0.5, 1, 1.5]
title1 = "Monthly GDP Growth"
title2 = "Monthly Unemployment Rate"
legend_location = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, axs = plt.subplots(2, 1, figsize=(8, 12))  # Use a 2x1 subplot grid for vertical layout

# Define new colors and markers for a fresh look
colors = ["forestgreen", "orangered"]
linestyles = ["-", "--"]
markers = ["o", "s"]
labels = [line_label1, line_label2]

# First subplot for GDP Growth
axs[0].plot(months, gdp_growth, color=colors[0], linestyle=linestyles[0], marker=markers[0], label=labels[0])
axs[0].set_title(title1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value)
axs[0].set_xlim(xlim_values)
axs[0].set_ylim(ylim_values)
axs[0].set_yticks(yticks_values)
axs[0].legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon)
axs[0].grid(True)
axs[0].tick_params(axis="both", which="both", length=0)

# Second subplot for Unemployment Rate
axs[1].plot(months, unemployment_rate, color=colors[1], linestyle=linestyles[1], marker=markers[1], label=labels[1])
axs[1].set_title(title2)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value)
axs[1].set_xlim(xlim_values)
axs[1].set_ylim(ylim_values)
axs[1].set_yticks(yticks_values)
axs[1].legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon)
axs[1].grid(True)
axs[1].tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout and visuals
plt.tight_layout()
plt.savefig("line_207.pdf", bbox_inches="tight")
