
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate new data for technology domain
months = np.arange(1, 13, 1)  # Months of the year
website_traffic = np.random.normal(15000, 3000, len(months))  # Simulate monthly website traffic
server_load = (
    10 * np.sin(0.5 * np.pi * months / 12) + 50
)  # Simulate average monthly server load

# Axes Limits and Labels
xlabel_value = "Month"

ylabel_value_1 = "Website Traffic"
ylabel_value_2 = "Server Load (%)"

# Labels
label_1 = "Monthly Website Traffic"
label_2 = "Average Server Load"

# Titles
title = "Website Traffic and Server Load Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot website traffic data with primary axis
color1 = "#1f77b4"  # blue
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color1)
ax1.plot(months, website_traffic, label=label_1, color=color1, marker="o", linestyle="-", linewidth=2)
ax1.tick_params(axis="y", labelcolor=color1)
ax1.set_xticks(months)
ax1.set_title(title)

# Create a second y-axis for server load
ax2 = ax1.twinx()  # Instantiate a second axes that shares the same x-axis
color2 = "#ff7f0e"  # orange
ax2.set_ylabel(ylabel_value_2, color=color2)  # We already handled the x-label with ax1
ax2.plot(
    months,
    server_load,
    label=label_2,
    color=color2,
    marker="s",
    linestyle="--",
    linewidth=2,
)
ax2.tick_params(axis="y", labelcolor=color2)

# Add legends to the plot
lines, labels = ax1.get_legend_handles_labels()
lines2, labels2 = ax2.get_legend_handles_labels()
ax1.legend(lines + lines2, labels + labels2, loc="upper left", frameon=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_214.pdf", bbox_inches="tight")
