
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data preparation
times = [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0]
calories_burned = [200, 220, 210, 215, 230, 225, 240, 235, 245, 250, 255]
heart_rate = [70, 72, 74, 73, 71, 70, 69, 68, 70, 72, 71]
sleep_quality = [7.0, 6.8, 7.2, 7.0, 7.1, 7.3, 7.4, 7.5, 7.3, 7.1, 7.2]

# Extracted variables
calories_label = "Calories Burned"
heart_rate_label = "Heart Rate"
sleep_quality_label = "Sleep Quality"

xlim_values = (0, 10)
ylim_values_calories = (190, 260)
ylim_values_heart_rate = (65, 75)
ylim_values_sleep_quality = (6, 8)

yticks_calories = [190, 210, 230, 250]
yticks_heart_rate = [65, 68, 71, 74]
yticks_sleep_quality = [6, 6.5, 7, 7.5, 8]

xlabel_value = "Day"
ylabel_value = "Value"

title_calories = "Calories Burned Over Time"
title_heart_rate = "Heart Rate Over Time"
title_sleep_quality = "Sleep Quality Over Time"

legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_frameon = False

grid_linestyle = "--"
grid_alpha = 0.5



# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(6, 9))
tick_params_color = "gray"

# First subplot: Calories Burned
axs[0].plot(
    times,
    calories_burned,
    label=calories_label,
    color="#2ca02c",
    clip_on=False,
    zorder=10,
    linestyle="-",
    marker="o",
)
axs[0].set_title(title_calories, y=1.1)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_calories)
axs[0].set_yticks(yticks_calories)
axs[0].set_ylabel(ylabel_value)
axs[0].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[0].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[0].tick_params(axis="both", which="both", color=tick_params_color)

# Second subplot: Heart Rate
axs[1].plot(
    times,
    heart_rate,
    label=heart_rate_label,
    color="#1f77b4",
    clip_on=False,
    zorder=10,
    linestyle="--",
    marker="x",
)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_heart_rate)
axs[1].set_yticks(yticks_heart_rate)
axs[1].set_title(title_heart_rate, y=1.1)
axs[1].set_ylabel(ylabel_value)
axs[1].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[1].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[1].tick_params(axis="both", which="both", color=tick_params_color)

# Third subplot: Sleep Quality
axs[2].plot(
    times,
    sleep_quality,
    label=sleep_quality_label,
    clip_on=False,
    zorder=10,
    color="#ff7f0e",
    linestyle="-.",
    marker="s",
)
axs[2].set_title(title_sleep_quality, y=1.1)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_sleep_quality)
axs[2].set_yticks(yticks_sleep_quality)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value)
axs[2].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[2].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[2].tick_params(
    axis="both",
    which="both",
    color=tick_params_color,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_216.pdf", bbox_inches="tight")
