
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data for philosophical trends over time
x = np.linspace(0, 20, 20)
trend_data = np.cos(x/2) + np.random.normal(0, 0.1, 20)  # Simulated trend data with noise
smoothed_data = np.convolve(trend_data, np.ones(5) / 5, mode="valid")  # Smoothed data
difference_data = np.diff(trend_data)  # Difference data
cumulative_data = np.cumsum(trend_data)  # Cumulative sum data

# Axes Limits and Labels
xlabel_value = "Philosophical Era"

ylabel_value_1 = "Trend Intensity"
ylabel_value_2 = "Change in Intensity"
ylabel_value_3 = "Cumulative Intensity"

# Labels
label_1 = "Smoothed Philosophical Trend"
label_2 = "Change in Trend Intensity"
label_3 = "Cumulative Intensity Over Time"

# Titles
title_1 = "Smoothed Philosophical Trends"
title_2 = "Change in Philosophical Trend Intensity"
title_3 = "Cumulative Intensity of Philosophical Trends"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(5, 10))

# First subplot: Smoothed Data
axs[0].plot(x[2:-2], smoothed_data, label=label_1, color="#8B4513", linestyle="--", marker="D")
axs[0].set_title(title_1)
axs[0].set_ylabel(ylabel_value_1)
axs[0].legend(loc="upper right")
axs[0].grid(True, linestyle="--", alpha=0.5)

# Second subplot: Difference Data
axs[1].plot(x[1:], difference_data, label=label_2, color="#4682B4", linestyle="-.", marker="o")
axs[1].set_title(title_2)
axs[1].set_ylabel(ylabel_value_2)
axs[1].legend(loc="upper right")
axs[1].grid(True, linestyle="--", alpha=0.5)

# Third subplot: Cumulative Sum
axs[2].plot(x, cumulative_data, label=label_3, color="#556B2F", linestyle=":", marker="x")
axs[2].set_title(title_3)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_3)
axs[2].legend(loc="upper right")
axs[2].grid(True, linestyle="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_218.pdf", bbox_inches="tight")
