
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

import numpy as np

np.random.seed(0)

# Timeline (Years)
t = np.arange(2000, 2021, 1)

# New Data
followers = np.random.normal(loc=5, scale=2, size=len(t)).cumsum() + 50  # In millions
donations = np.random.normal(loc=2, scale=0.5, size=len(t)).cumsum() + 10  # In $ millions
participation = np.random.uniform(low=70, high=90, size=len(t))  # In %
publications = np.random.poisson(lam=3, size=len(t)).cumsum() + 50  # Number of books

# Labels for legend
label_followers = "Number of Followers"
label_donations = "Donations Collected"
label_participation = "Event Participation"
label_publications = "Books Published"

# Plot configuration
xlim_values = (2000, 2020)
ylim_values_followers = (50, 130)
ylim_values_donations = (10, 35)
ylim_values_participation = (60, 100)
ylim_values_publications = (50, 120)

xlabel_value = "Year"
ylabel_value_followers = "Followers (in millions)"
ylabel_value_donations = "Donations (in $ millions)"
ylabel_value_participation = "Participation (%)"
ylabel_value_publications = "Books Published"

title_followers = "Number of Followers Over Time"
title_donations = "Donations Collected Over Time"
title_participation = "Participation in Events Over Time"
title_publications = "Books Published Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(4, 1, figsize=(8, 16))

# Colors
color_followers = "#8E44AD"
color_donations = "#2980B9"
color_participation = "#27AE60"
color_publications = "#C0392B"

# Plot Followers
axs[0].plot(t, followers, label=label_followers, color=color_followers, linestyle='-', marker='o')
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_followers)
axs[0].set_title(title_followers, y=1.1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_followers)

# Plot Donations
axs[1].plot(t, donations, label=label_donations, color=color_donations, linestyle='--', marker='x')
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_donations)
axs[1].set_title(title_donations, y=1.1)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_donations)

# Plot Participation
axs[2].plot(t, participation, label=label_participation, color=color_publications, linestyle='-.', marker='s')
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_participation)
axs[2].set_title(title_participation, y=1.1)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_participation)

# Plot Publications
axs[3].plot(t, publications, label=label_publications, color=color_participation, linestyle=':', marker='d')
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_publications)
axs[3].set_title(title_publications, y=1.1)
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_publications)

# Legend configuration
for ax in axs.flat:
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_221.pdf", bbox_inches="tight")
