
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Time variable, representing the timeline of philosophical thought (e.g., centuries)
t = np.arange(0, 21, 1)  # Simplified time from 0 to 20

# Simulated data for different schools of philosophical thought
logic = np.sin(t / 3) + np.random.normal(0, 0.1, t.shape)
ethics = np.log(t + 1) + np.random.normal(0, 0.1, t.shape)
metaphysics = np.exp(-t / 10) + np.random.normal(0, 0.05, t.shape)
epistemology = 1 / (1 + np.exp(-0.5 * (t - 10))) + np.random.normal(0, 0.05, t.shape)

# Labels for legend
label_logic = "Logic"
label_ethics = "Ethics"
label_metaphysics = "Metaphysics"
label_epistemology = "Epistemology"

# Plot configuration
xlim_values = (0, 20)
ylim_values_logic_ethics = (-1.5, 3.5)
ylim_values_metaphysics = (0, 1.5)
ylim_values_epistemology = (0, 1.2)

xlabel_value = "Time (Centuries)"
ylabel_value = "Interest Level"
ylabel_value_metaphysics_epistemology = "Influence Level"

title_logic = "Trends in Logic"
title_ethics = "Trends in Ethics"
title_metaphysics = "Decline of Metaphysics"
title_epistemology = "Rise of Epistemology"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(4, 1, figsize=(6, 12))

axs[0].plot(t, logic, label=label_logic, color="navy", linestyle="--", linewidth=2)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_logic_ethics)
axs[0].set_title(title_logic, y=1.1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value)

axs[1].plot(t, ethics, label=label_ethics, color="teal", linestyle=":", linewidth=2)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_logic_ethics)
axs[1].set_title(title_ethics, y=1.1)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value)

axs[2].plot(t, metaphysics, label=label_metaphysics, color="grey", linestyle="-", linewidth=2)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_metaphysics)
axs[2].set_title(title_metaphysics, y=1.1)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_metaphysics_epistemology)

axs[3].plot(t, epistemology, label=label_epistemology, color="darkred", linestyle="-.", linewidth=2)
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_epistemology)
axs[3].set_title(title_epistemology, y=1.1)
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_metaphysics_epistemology)

for ax in axs.flat:
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_222.pdf", bbox_inches="tight")
