
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generated financial data (Stock prices over days)
days1 = np.array([1, 2, 3, 4, 5])
prices1 = np.array([105, 108, 110, 109, 107])
volatility1 = np.array([2, 1, 3, 2, 2])

days2 = np.array([1, 2, 3, 4])
prices2 = np.array([150, 152, 149, 146])
volatility2 = np.array([3, 2, 2, 2])

days3 = np.array([1, 2, 3, 4, 5, 6])
prices3 = np.array([200, 195, 205, 210, 215, 213])
volatility3 = np.array([4, 3, 3, 2, 4, 3])

days4 = np.array([1, 2, 3, 4, 5])
prices4 = np.array([85, 88, 90, 87, 84])
volatility4 = np.array([1, 2, 2, 2, 1])

# Titles and labels
titles = [
    "Company A - Stock Price Trend",
    "Company B - Stock Price Trend",
    "Company C - Stock Price Trend",
    "Company D - Stock Price Trend",
]
xlabel = "Days"
ylabel = "Stock Price ($)"
legend_labels = ["Stock Prices"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x2 subplots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Flatten the axis array for easy iteration
axs = axs.flatten()

# Setting data for each subplot
data = [(days1, prices1, volatility1), (days2, prices2, volatility2), (days3, prices3, volatility3), (days4, prices4, volatility4)]

# Custom colors and styles
colors = ['#2ca02c', '#1f77b4', '#ff7f0e', '#d62728']
markers = ['o', 's', 'D', '^']
linestyles = ['-', '--', '-.', ':']

# Plot with error bars in each subplot
for i, (ax, (x, y, e), title) in enumerate(zip(axs, data, titles)):
    ax.errorbar(
        x, y, yerr=e, fmt=linestyles[i], color=colors[i], ecolor="gray", capsize=5, markersize=6, marker=markers[i]
    )
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel, fontsize=12)
    ax.set_ylabel(ylabel, fontsize=12)
    ax.grid(True, alpha=0.5)
    ax.set_xticks(x)
    ax.set_yticks(np.linspace(min(y) - max(e), max(y) + max(e), num=5, endpoint=True))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_224.pdf", bbox_inches="tight")
